/*
    Lock.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/Lock.h,v $
        Author(s):             George Fankhauser
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.3 $
        Creation Date:         
        Last Date of Change:   $Date: 1999/12/13 21:48:37 $      by: $Author: ruf $
        
        
        $Log: Lock.h,v $
        Revision 1.3  1999/12/13 21:48:37  ruf
        GNU General Public Licence Update

        Revision 1.2  1997/03/31 20:27:41  gfa
        debugging (no error found :-)

 * Revision 1.1  1997/03/22  12:59:34  gfa
 * Initial revision
 *
*/
#ifndef _LOCK_H_
#define _LOCK_H_

#include "Topsy.h"


typedef struct LockDesc_t {
    Boolean lockVariable;
} LockDesc;

typedef LockDesc* Lock;


void lockInit(Lock lock);
void lock(Lock lock);
void unlock(Lock lock);
Boolean lockTry(Lock lock);

#endif