/*
    Lock.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/Lock.c,v $
        Author(s):             George Fankhauser
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.4 $
        Creation Date:         
        Last Date of Change:   $Date: 1999/12/13 21:48:37 $      by: $Author: ruf $
        
        
        $Log: Lock.c,v $
        Revision 1.4  1999/12/13 21:48:37  ruf
        GNU General Public Licence Update

        Revision 1.3  1999/10/22 19:22:39  gfa
        *** empty log message ***

        Revision 1.2  1999/10/21 20:22:32  jeker
        first commit for the R4k support

        Revision 1.1  1997/03/22 12:59:31  gfa
        Initial revision

*/

#include "Lock.h"
#include "Support.h"

/*
 * a simple spin-lock that assumes a bus-interlocked testAndSet function
 * that takes a pointer to a Boolean and returns TRUE if the lock was taken 
 * FALSE if it could not be locked.
 */
 
/* the lock is in unlocked state at the beginning */
void lockInit(Lock lock)
{
    lock->lockVariable = FALSE;
}

/* busy waits until the lock is available */
void lock(Lock lock)
{
	while (!testAndSet(&(lock->lockVariable)))
	    ;
}

void unlock(Lock lock)
{
    lock->lockVariable = FALSE;
}

/* try once and give up if it can't be locked */
Boolean lockTry(Lock lock)
{
    return (testAndSet(&(lock->lockVariable)));
}
