/*
    List.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/List.h,v $
        Author(s):             George Fankhauser
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.9 $
        Creation Date:         
        Last Date of Change:   $Date: 1999/12/13 21:48:37 $      by: $Author: ruf $
        
        
        $Log: List.h,v $
        Revision 1.9  1999/12/13 21:48:37  ruf
        GNU General Public Licence Update

        Revision 1.8  1997/03/31 20:27:18  gfa
        new functions moveToEnd and swap

 * Revision 1.7  1997/03/28  11:08:24  gfa
 * fixed lost iteration in interface...
 *
 * Revision 1.6  1997/03/28  10:44:45  gfa
 * addAtEnd (new function added)
 *
 * Revision 1.5  1997/03/27  17:07:17  gfa
 * added doubly linked style and element hinting (needed by the scheduler)
 *
 * Revision 1.4  1997/03/24  20:32:47  gfa
 * uses only dynamic memory from now on...
 *
 * Revision 1.3  1997/03/11  08:18:18  gfa
 * *** empty log message ***
 *
 * Revision 1.2  1997/03/09  20:52:07  gfa
 * first tested and purified
 * version of List.[ch]
 *
 * Revision 1.1  1997/03/08  18:57:00  gfa
 * Initial revision
 *
*/
#ifndef _LIST_H_
#define _LIST_H_

#include "Topsy.h"
#include "MMHeapMemory.h"

#define LIST_ERROR 0
#define LIST_OK 1

typedef struct ListElement_t {
    void* item;
    struct ListElement_t* next;
    struct ListElement_t* prev;
} ListElementDesc;

typedef ListElementDesc* ListElement;

typedef struct ListDesc_t {
    ListElement first;
    ListElement current;
    ListElement last;
} ListDesc;

typedef ListDesc* List;

/* basic list functions */
List listNew();
Error listFree(List list);

Error listAddInFront(List list, void* item, Address* hint);
Error listAddAtEnd(List list, void* item, Address* hint);
Error listRemove(List list, void* item, Address hint);

/* advanced operations that cause no alloc/free */
Error listMoveToEnd(List list, void* item, Address hint);
Error listSwap(List listFrom, List listTo, void* item, Address hint);

/* iteration */
Error listGetFirst(List list, void** itemPtr);
Error listGetNext(List list, void** itemPtr);

#endif
