/*
    HashList.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/HashList.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.12 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:36 $      by: $Author: ruf $
	
	
	$Log: HashList.h,v $
	Revision 1.12  1999/12/13 21:48:36  ruf
	GNU General Public Licence Update
	
	Revision 1.11  1997/04/23 11:56:34  gfa
	*** empty log message ***
	
 * Revision 1.10  1997/03/24  20:33:31  gfa
 * uses only dynamic memory from now on...
 *
 * Revision 1.9  1997/03/16  22:13:38  gfa
 * *** empty log message ***
 *
 * Revision 1.8  1997/03/13  23:57:50  gfa
 * no changes
 *
 * Revision 1.7  97/03/09  20:52:40  gfa
 * added GET_STATIC... macro
 * 
 * Revision 1.6  1997/03/06  16:14:17  gfa
 * changed constants from OK to HASHOK etc.
 *
 * Revision 1.5  1997/02/22  19:33:18  gfa
 * *** empty log message ***
 *
 * Revision 1.4  1997/02/22  19:21:23  gfa
 * purify'ed and tested version
 * supports now the mixed use of static and dynamic memory
 * to allow kernel data structures to be accessed on startup
 * and grow dynamically later
 *
 * Revision 1.3  1997/02/13  15:49:14  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.2  1997/02/12  15:37:48  gfa
 * *** empty log message ***
 *
 * Revision 1.1  1997/02/04  11:46:04  topsy
 * Initial revision
 *
*/

#ifndef _HASHLIST_H_
#define _HASHLIST_H_

#include "Topsy.h"
#include "MMHeapMemory.h"


#define HASHLISTSIZE 	17 /* the 7th prime */
#define HASHERROR 	 0
#define HASHOK 		 1
#define HASHNOTFOUND 	 2
#define HASHDUPLICATEKEY 3

typedef struct HashListElementDesc_t {
	void* item;
	unsigned long int key;
	struct HashListElementDesc_t* next;
} HashListElementDesc;

typedef HashListElementDesc* HashListElement;

typedef struct HashList_t {
	HashListElement table[HASHLISTSIZE];
} HashListDesc;

typedef HashListDesc* HashList;


HashList hashListNew();
Error hashListAdd(HashList list, void* data, unsigned long int key);
Error hashListGet(HashList list, void** data, unsigned long int key);
Error hashListRemove(HashList list, unsigned long int key);


#endif
