/*
    Error.h, Copyright 6.3.97 (c) by Christian Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/Error.h,v $
 	Author(s):             Christian Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.5 $
 	Creation Date:         6.3.97
 	Last Date of Change:   $Date: 1999/12/13 21:48:36 $      by: $Author: ruf $
	
	
	$Log: Error.h,v $
	Revision 1.5  1999/12/13 21:48:36  ruf
	GNU General Public Licence Update
	
	Revision 1.4  1998/04/06 10:04:33  gfa
	added printregisters
	
	Revision 1.3  1997/04/06 18:47:02  gfa
	*** empty log message ***

 * Revision 1.2  97/03/19  21:43:20  conrad
 * *** empty log message ***
 * 
 * Revision 1.1  1997/03/06  16:17:23  conrad
 * Initial revision
 *
*/

#ifndef __ERROR_H
#define __ERROR_H

/*
 * There are 3 debug levels:
 *       INFO_LEVEL     : for information
 *       WARNING_LEVEL  : anomality
 *       ERROR_LEVEL    : error (no panic nessary)
 */
#define INFO_LEVEL      1
#define WARNING_LEVEL   2
#define ERROR_LEVEL     3

/* Not possible to mask panic messages */
#define PANIC(s)       panic( getCurrentThreadName(), __FILE__, __LINE__, s)

#if DEBUG_LEVEL <= INFO_LEVEL
#define INFO(s)        info(getCurrentThreadName(), __FILE__, __LINE__, s)
#else
#define INFO(s)
#endif

#if DEBUG_LEVEL <= WARNING_LEVEL
#define WARNING(s)     warning(getCurrentThreadName(), __FILE__, __LINE__, s)
#else
#define WARNING(s)
#endif

#if DEBUG_LEVEL <= ERROR_LEVEL
#define ERROR(s)       error(getCurrentThreadName(), __FILE__, __LINE__, s)
#else
#define ERROR(s)
#endif


void panic( char* threadName,
	    const char* fileName,
	    int line,
	    char* errorMessage);

void error( char* threadName,
	    const char* fileName,
	    int line,
	    char* errorMessage);

void warning( char* threadName,
	      const char* fileName,
	      int line,
	      char* errorMessage);

void info( char* threadName,
	   const char* fileName,
	   int line,
	   char* errorMessage);

void printRegisters();

#endif __ERROR_H
