/*
    Error.c, Copyright 6.3.97 (c) by C. Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/Error.c,v $
 	Author(s):             C. Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.13 $
 	Creation Date:         6.3.97
 	Last Date of Change:   $Date: 1999/12/13 21:48:36 $      by: $Author: ruf $
	
	
	$Log: Error.c,v $
	Revision 1.13  1999/12/13 21:48:36  ruf
	GNU General Public Licence Update
	
	Revision 1.12  1999/04/08 11:40:17  jeker
	added some new files, modified some others for unix port
	
	Revision 1.11  1998/04/08 15:09:52  gfa
	*** empty log message ***

	Revision 1.10  1998/04/08 08:54:07  gfa
	added '*** ' to output of printreg

	Revision 1.9  1998/04/07 15:32:16  gfa
	printreg

	Revision 1.8  1998/04/06 10:04:33  gfa
	added printregisters

	Revision 1.7  1997/04/07 07:49:16  gfa
	adjusted IOConsole/Hal include

 * Revision 1.6  97/04/06  18:47:02  gfa
 * *** empty log message ***
 * 
 * Revision 1.5  97/03/31  20:28:31  gfa
 * cosmetics (missing blank)
 * 
 * Revision 1.4  1997/03/19  21:43:12  conrad
 * cosmetics
 *
 * Revision 1.3  1997/03/11  08:17:56  gfa
 * *** empty log message ***
 *
 * Revision 1.2  1997/03/10  19:58:32  gfa
 * added infinite loop to panic()
 *
 * Revision 1.1  1997/03/06  16:17:23  conrad
 * Initial revision
 *
*/

#include "Topsy.h"
#include "Error.h"
#include "IO.h"
#include "List.h"

extern List threadList;
extern int exceptionContextFlag;


void errLog( char* threadName,
	     const char* fileName,
	     int lineNumber,
	     char* errorMessage)
{
    ioConsolePutString(threadName);
    if (exceptionContextFlag == 1) {
	ioConsolePutString(" (*in exc*)");
    }
    ioConsolePutString(", ");
    ioConsolePutString(fileName);
    ioConsolePutString(":");
    ioConsolePutInt(lineNumber);
    ioConsolePutString(" ] ");
    ioConsolePutString(errorMessage);
    ioConsolePutString("\n");
}

void error( char* threadName,
	    const char* fileName,
	    int lineNumber,
	    char* errorMessage)
{
    ioConsolePutString("*** ERROR [ ");
    errLog( threadName, fileName, lineNumber, errorMessage);
}

void warning( char* threadName,
	      const char* fileName,
	      int lineNumber,
	      char* errorMessage)
{
    ioConsolePutString("** WARNING [ ");
    errLog( threadName, fileName, lineNumber, errorMessage);
}

void info( char* threadName,
	   const char* fileName,
	   int lineNumber,
	   char* errorMessage)
{
    ioConsolePutString("* INFO [ ");
    errLog( threadName, fileName, lineNumber, errorMessage);
}

void panic ( char *threadName,
	     const char *fileName,
	     int lineNumber,
	     char *errorMessage)
{
    ioConsolePutString("**** PANIC [ ");
    errLog( threadName, fileName, lineNumber, errorMessage);
    while (TRUE) {
    }
}

