/*
    Configuration.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Topsy/Configuration.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.16 $
 	Creation Date:         
 	Last Date of Change:   $Date: 2001/02/01 08:37:14 $      by: $Author: gfa $
	
	
	$Log: Configuration.h,v $
	Revision 1.16  2001/02/01 08:37:14  gfa
	*** empty log message ***
	
	Revision 1.15  2000/06/05 14:06:27  gfa
	*** empty log message ***
	
	Revision 1.14  1999/12/13 21:48:36  ruf
	GNU General Public Licence Update
	
	Revision 1.13  1999/10/25 12:30:46  gfa
	*** empty log message ***
	
	Revision 1.12  1999/10/23 21:31:17  gfa
	*** empty log message ***
	
	Revision 1.11  1999/10/19 14:59:20  gfa
	*** empty log message ***
	
	Revision 1.10  1999/09/17 08:02:46  gfa
	*** empty log message ***

	Revision 1.9  1999/01/14 19:24:35  cjeker
	pre2.0 release

	Revision 1.8  1998/03/26 19:46:33  gfa
	1.1 upgrade
	
	Revision 1.7  1997/04/23 18:22:22  conrad
	stack size set to 1K

 * Revision 1.6  1997/04/18  16:28:56  conrad
 * *** empty log message ***
 *
 * Revision 1.5  1997/04/17  12:03:04  conrad
 * if nbcycles is too large, it fails ...
 *
 * Revision 1.4  1997/04/17  11:09:01  conrad
 * adding of a constant NBCYCLESFORDELAY for ioDelayAtLeastCycles() function
 *
 * Revision 1.3  1997/03/31  20:28:04  gfa
 * fiddled with timeslice and reduced stack to 512 bytes
 *
 * Revision 1.2  1997/03/27  13:55:30  conrad
 * *** empty log message ***
 *
 * Revision 1.1  1997/03/26  16:12:50  conrad
 * Initial revision
 *
 * Revision 1.3  1997/03/26  10:58:01  gfa
 * added endien-ness defines
 *
 * Revision 1.2  1997/03/24  11:03:24  conrad
 * adding of stack size
 *
 * Revision 1.1  1997/03/23  12:38:16  gfa
 * Initial revision
 *
*/
#ifndef _CONFIGURATION_H_
#define _CONFIGURATION_H_

/* general, messages, prompts, look and feel 
 */
#if defined(__MIPSEB__) || defined(__BIG_ENDIAN__)
#define TOPSY_BIG_ENDIAN
#endif


/* memory parameters 
 */
#define KERNELHEAPSIZE   (64*1024)   /* kernel heap size */


/* threads, IPC 
 */
#define TIMESLICE         10   /* how long a thread may run, in milliseconds */
#define NBPRIORITYLEVELS   3   /* 0 for highest priority */
#define MAXNBMSGINQUEUE    4   /* message queue length */
#define MAXNAMESIZE       24   /* max thread name size (in characters) */
#define TM_DEFAULTTHREADSTACKSIZE   (8*1024)    /* max stack size in bytes */
#define PREEMPTIVE_MODE   TRUE /* true turns preemptive timeslicing on */

/* io features 
 */
#define NBCYCLESFORDELAY 10    /* each time a write occurs onto a driver, */
                               /* at least NULL-operations are performed  */
/* debugging features */
//#define MMDEBUG

#endif
