/*
    LWThreads.S, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
*/

#include "asm.h"

// extern lwSave(void*, void*, void*);
    FRAME(lwSave)
    .set noreorder
    sw    sp, 0(a0)
    sw    fp, 0(a1)
    j         ra
    sw    a3, 0(a2)  // a3 is old ra here
    .set reorder
    .end lwSave
    
// extern lwRestore(long, long, long);
    FRAME(lwRestore)

    .set noreorder
    move    sp, a0
    j           a2
    move    fp, a1
    .set reorder
    .end lwRestore
    
// extern lwSetArg(long parameter);
    FRAME(lwSetArg)

    .set noreorder
    // not needed... ;-)
    // move    a0, a0
    j          ra
    nop
    .set reorder
    .end lwSetArg

