/*
    LWThreads.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
#include "Messages.h"

#define LW_SELF       -3
#define LW_NO_THREAD  -2

#define LW_FAILED      2
#define LW_OK          3

#define LW_STATE_READY             2
#define LW_STATE_WAIT              3
#define LW_THREAD_DOES_NOT_EXIST   4

#define LW_STACKSIZE   1024

typedef long LWError;

typedef struct LWThreadContext_t {
    unsigned long stackPointer;
    unsigned long framePointer;
    unsigned long programCounter;
    char stack[LW_STACKSIZE];
} LWThreadContext;

typedef struct LWThreadDesc_t {
    Message* msg;
    ThreadId from;
    int state;
    ThreadId next;
    ThreadId prev;
    LWThreadContext context;
} LWThreadDesc;

typedef LWThreadDesc* LWThread;

typedef struct LWThreadArrayDesc_t {
    unsigned int N;   // how many total
    unsigned int n;   // how many right now
    ThreadId current; // index to running
    LWThread a;       // array: LWThreadDesc a[];
} LWThreadArrayDesc;


LWError lwInit(unsigned int noOfThreads);
LWError lwExit();
LWError lwMsgSend(ThreadId to, Message *msg);
LWError lwMsgRecv(ThreadId* from,
		MessageId msgId,
		Message* msg,
		int timeOut);
LWError lwStart(ThreadId* id,
		ThreadMainFunction mainFunction, 
		ThreadArg parameter, 
		char *name);
LWError lwKill(ThreadId id);
void    lwYield();