/*
    TMClock.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
*/

#ifndef _TMCLOCK_H_
#define _TMCLOCK_H_

#include "tm-include.h"
#include "Configuration.h"	// for value of timeslice

/* The 2 timers of the 82C54 programmable interval timer */
typedef enum { CLOCK0, CLOCK1 } ClockId;

/* Used modes for the 82C54, currently a single mode */
typedef enum { RATEGENERATOR, SWTRIGGER } ClockMode;

/* Configuration of the 82C54 (each counter separately) */
Error setClockValue( ClockId cId, int period, ClockMode cMode);

void tmResetClockInterrupt( ClockId cId);

/* RTC routines  * Seconds difference from January 1st 1998, 00:00, UTC */
unsigned long tmRTClockGetSeconds();

void tmRTClockSetSeconds(unsigned long seconds, unsigned long microSeconds);


#endif
