/*
    TMClock.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	Initial revision

*/

#include "TMHal.h"
#include "IOHal.h"
#include "IODevice.h"
#include "TMScheduler.h"
#include "Support.h"
#include "TMClock.h"

#include "Unix.h"

/*
 * This function initializes the clock on the board.
 */
Error setClockValue( ClockId cId, int period, ClockMode cMode)
{
    ualarm(period*1000, period*1000);
    return TM_OK;
}

/* not needed in unix */
void tmResetClockInterrupt(ClockId cId) {}

/* since we don't have an RTC installed we don't do anything here
 * otherwise we would calculate the seconds 
 * since January 1st 1998, 00:00, UTC, and return or set them
 */
unsigned long tmRTClockGetSeconds()
{
    // gettimeofday
    return 0;
}

void tmRTClockSetSeconds(unsigned long seconds, unsigned long microSeconds)
{
    // settimeofday
    return;
}
