/*
    tm-include.h, Copyright  (c) by Christian Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/tm-include.h,v $
 	Author(s):             Christian Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.18 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:34 $      by: $Author: ruf $
	
	
	$Log: tm-include.h,v $
	Revision 1.18  1999/12/13 21:48:34  ruf
	GNU General Public Licence Update
	
	Revision 1.17  1997/04/23 09:04:54  gfa
	formatting
	
 * Revision 1.16  1997/04/01  16:23:41  conrad
 * *** empty log message ***
 *
 * Revision 1.15  1997/03/28  12:38:23  conrad
 * *** empty log message ***
 *
 * Revision 1.14  1997/03/28  11:41:54  conrad
 * using of generic lists with hint field for scheduler
 *
 * Revision 1.13  1997/03/23  12:40:51  gfa
 * moved queue size etc. to config
 *
 * Revision 1.12  97/03/21  20:01:53  conrad
 * new idle thread
 * 
 * Revision 1.11  1997/03/16  22:13:16  gfa
 * *** empty log message ***
 *
 * Revision 1.10  1997/03/13  14:25:02  conrad
 * Simplification of the pending structure
 *
 * Revision 1.9  1997/03/12  17:53:48  conrad
 * Debugging version
 *
 * Revision 1.8  1997/03/11  20:07:06  conrad
 * First version to be debugged with Simulator
 *
 * Revision 1.7  1997/03/09  20:46:21  gfa
 * *** empty log message ***
 *
 * Revision 1.6  1997/02/25  16:58:14  conrad
 * minor change in scheduler structure
 *
 * Revision 1.5  1997/02/24  21:35:02  conrad
 * incomplete version
 *
 * Revision 1.4  1997/02/21  16:52:29  conrad
 * very incomplete status due to major changes ...
 *
 * Revision 1.3  1997/02/21  09:15:13  conrad
 * Intermediate status (not yet completed)
 *
 * Revision 1.2  1997/02/19  17:46:24  conrad
 * *** empty log message ***
 *
 * Revision 1.1  1997/02/18  18:27:47  conrad
 * Initial revision
 *
*/

#ifndef __TMINCLUDE_H
#define __TMINCLUDE_H

#include "Threads.h"
#include "HashList.h"
#include "List.h"
#include "Topsy.h"
#include "Messages.h"
#include "Configuration.h"

/* Internal TM error messages */
#define TM_OK                       1
#define TM_MSGQUEUEOVERFLOW        -1
#define TM_THREADNOTFOUND          -2
#define TM_THREADSTARTFAILED        0     /* as threadStart() returns an id (!= 0) */
#define TM_THREADKILLFAILED        -3
#define TM_NOSUCHMESSAGE           -4
#define TM_FAILED                  -5

/* Forward definitions - these are necessary to prevent cyclical references */
typedef struct Thread_t* ThreadPtr;
typedef struct ProcContext_t* ProcContextPtr;  /* proc. dependent context */

/* Thread status in scheduler */
typedef enum { RUNNING, READY, BLOCKED} SchedStatus;

/* Thread priority level (must match NBPRIORITYLEVELS)
   Decreasing order of priority */
typedef enum { KERNEL_PRIORITY, USER_PRIORITY, IDLE_PRIORITY } ThreadPriority;

/* Two queues for each priority level */
typedef struct SchedPriority_t {
    List ready;
    List blocked;
} SchedPriority;

typedef struct Scheduler_t {
    ThreadPtr running;
    SchedPriority prioList[NBPRIORITYLEVELS];
} Scheduler;

typedef enum { NOT_WAITING, WAITING, FILLED} PendingStatus;

/* Message queue for each thread */
typedef struct MessageQueue_t {
    int freeList;                      /* index of first free cell */
    int busyList;                      /* index of first valid message */
    int ctrl[MAXNBMSGINQUEUE];         /* management of message list */
    Message msg[MAXNBMSGINQUEUE];      /* static array of messages */
    PendingStatus msgPendingStatus;    /* indicates if a message is pending */
    Message* msgPendingPtr;            /* reference on pending message */
    ThreadId threadIdPending;          /* expected message sender */
    MessageId msgIdPending;            /* expected message type */
} MessageQueue;

/* Statistics about threads that may be gathered */
typedef struct ThreadStatistics_t {
    int cpuCycles;
} ThreadStatistics;

/* Scheduler specific data in each Thread structure */
typedef struct SchedulerInfo_t {
    SchedStatus status;		/* BLOCKED, READY, RUNNING */
    ThreadPriority priority;    /* Priority of the thread */
    Address hint;               /* Backwards reference on list descriptor */
} SchedulerInfo;

/* Main thread structure */
typedef struct Thread_t {
    ProcContextPtr contextPtr;	/* Processor dependent context */
    ThreadId id;		/* Processor independent */
    char name[MAXNAMESIZE];	/* Logical name of the thread */
    ThreadId parentId;		/* Thread id of parent thread */
    Address stackStart;		/* Start of stack */
    Address stackEnd;		/* End of stack */
    MessageQueue msgQueue;	/* Message queue */
    SchedulerInfo schedInfo;    /* Scheduler specific data */
    ThreadStatistics stat;	/* Various statistics */
} Thread;


#endif __TMINCLUDE_H
