/*
    TMHal.h, Copyright  (c) by Christian Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/mips/TMHal.h,v $
 	Author(s):             Christian Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.35 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/14 13:28:56 $
	
	
	$Log: TMHal.h,v $
	Revision 1.35  1999/12/14 13:28:56  ruf
	GNU GPL fix: missing #ifdef's inserted, Platform.mips.solaris: LCC=gcc set
	
	Revision 1.34  1999/12/13 21:48:35  ruf
	GNU General Public Licence Update
	
	Revision 1.33  1999/10/29 08:25:40  jeker
	*** empty log message ***
	
	Revision 1.32  1999/10/27 19:07:47  jeker
	fixes for R3k R4k port (restoreContext)

	Revision 1.31  1999/10/27 11:05:02  jeker
	fixes R4k R3k port

	Revision 1.30  1999/10/27 04:51:09  jeker
	*** empty log message ***

	Revision 1.29  1999/10/23 19:07:15  jeker
	added Makefile.SimOS.mips and did some code cleanup

	Revision 1.28  1999/10/23 14:19:47  jeker
	first cleanup for R4k support

	Revision 1.27  1999/10/21 20:22:31  jeker
	first commit for the R4k support

	Revision 1.26  1999/06/06 20:55:21  jeker
	putting everything together for Topsy 2.0

	Revision 1.25  1999/04/08 11:40:16  jeker
	added some new files, modified some others for unix port

	Revision 1.24  1999/01/08 22:07:21  cjeker
	more bug fixes

	Revision 1.23  1999/01/08 21:28:01  cjeker
	moved branchDelayBit handling to TMHalAsm.S
	
	Revision 1.22  1997/04/23 13:26:49  gfa
	fixed missing AT in save/restore
	
 * Revision 1.21  1997/04/23  09:10:28  gfa
 * formatting, comments adjusted
 *
 * Revision 1.20  1997/04/07  09:23:00  gfa
 * changed interrupt handler management to include the argument and arg table
 *
 * Revision 1.19  97/04/06  18:55:43  gfa
 * changed enable/disableInterrupt functions
 * 
 * Revision 1.18  1997/03/31  20:33:54  gfa
 * added low level register access functions
 *
 * Revision 1.17  1997/03/21  19:29:51  conrad
 * Prepared for introducing an idle thread
 *
 * Revision 1.16  1997/03/21  16:14:23  conrad
 * changed restoreContext() to check if a new threadPtr is NULL, if yes, restore
 * of a 'fake' idle context
 *
 * Revision 1.15  1997/03/21  13:55:07  conrad
 * *** empty log message ***
 *
 * Revision 1.14  1997/03/18  17:43:21  conrad
 * splitting of TMHal and TMClock
 *
 * Revision 1.13  1997/03/18  16:33:01  conrad
 * Adding of parenthesis for #define statements, necessary for ulterior
 * casting !!!
 *
 * Revision 1.12  1997/03/12  17:54:22  conrad
 * Debugging Version
 *
 * Revision 1.11  1997/03/11  20:07:35  conrad
 *  First version to be debugged with Simulator
 *
 * Revision 1.10  1997/03/09  20:45:14  gfa
 * declared assembler labels in header file
 *
 * Revision 1.9  1997/03/07  13:01:00  conrad
 * Adding of error module
 *
 * Revision 1.8  1997/03/04  16:56:28  conrad
 * minor changes
 *
 * Revision 1.7  1997/02/27  14:38:40  conrad
 * minor changes
 *
 * Revision 1.6  1997/02/26  17:34:39  conrad
 * Adding of hi and lo in ProcContext
 *
 * Revision 1.5  1997/02/19  17:46:51  conrad
 * *** empty log message ***
 *
 * Revision 1.4  1997/02/18  18:28:39  conrad
 * Introduction of tm-include.h
 *
 * Revision 1.3  1997/02/18  17:25:56  conrad
 * *** empty log message ***
 *
 * Revision 1.2  1997/02/13  15:45:17  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.1  1997/02/13  07:30:17  conrad
 * Initial revision
 *
*/

#ifndef __TMHAL_H
#define __TMHAL_H

#include "tm-include.h"
#include "cpu.h"
#include "Exception.h"
#include "SupportMIPS.h"

#define MAXNBOFEXCEPTIONS    32
#define MAXNBOFINTERRUPTS     8

/* THREADRETURNADDR is defined inside TMHal.h to allow portability.... :-) */
#define THREADRETURNADDR      4

#define STATUS_INT_ENABLE_KERNEL_PREV (getPRID() == PRID_R3k)?\
					(SR_IEp | (SR_KUp & 0)):(SR_IE | SR_KSU_KERNEL | SR_EXL)
#define STATUS_INT_ENABLE_USER_PREV (getPRID() == PRID_R3k)?\
					(SR_IEp | SR_KUp):(SR_IE | SR_KSU_USER | SR_EXL)

/* Processor dependent thread information */
typedef struct ProcContext_t {
    Register returnValue[2];       /* v0 - v1 */
    Register argument[4];          /* a0 - a3 */
    Register callerSaved[10];      /* t0 - t9 */
    Register calleeSaved[8];       /* s0 - s7 */
    Register globalPointer;        /* gp */
    Register stackPointer;         /* sp */
    Register framePointer;         /* fp */
    Register returnAddress;        /* ra */
    Register programCounter;       /* pc */
    Register hilo[2];              /* hi, lo multiplier registers */
    Register statusRegister;       /* sr after trapping */
    Register assemblerTemp;        /* assembler temp, used also by gcc */
} ProcContext;

/* Saving and restoring current thread context (assembler procedures) */
void saveContext(ProcContextPtr contextPtr);
/* global function */
void (*restoreContext)(ProcContextPtr contextPtr);
/* processor specific functions */
void restoreContext_R3k(ProcContextPtr contextPtr);
void restoreContext_R4k(ProcContextPtr contextPtr);

/* operations on the thread context are machine dependent and 
 * encapsulated in the following functions. On CISC machines
 * most of these ops must be implemented using the current SP of
 * the context.
 */
void tmSetReturnValue(ProcContextPtr contextPtr, Register value);
void tmSetStackPointer(ProcContextPtr contextPtr, Register value);
void tmSetReturnAddress(ProcContextPtr contextPtr, Register value);
void tmSetProgramCounter(ProcContextPtr contextPtr, Register value);
void tmSetStatusRegister(ProcContextPtr contextPtr, Register value);
void tmSetFramePointer(ProcContextPtr contextPtr, Register value);
void tmSetArgument0(ProcContextPtr contextPtr, Register value);
void tmSetArgument1(ProcContextPtr contextPtr, Register value);
void tmSetMachineDependentRegisters(ProcContextPtr contextPtr, AddressSpace space);

void enableInterruptInContext( InterruptId intId, ProcContextPtr contextPtr);
void disableInterruptInContext( InterruptId intId, ProcContextPtr contextPtr);
void enableAllInterruptsInContext( ProcContextPtr contextPtr);

/* installs code by copying generalExceptionHandler()'s and 
 * UTLBMissHandler()'s code at certain mips specific addresses
 */
void tmInstallExceptionCode();

/* Syscall exception handler (set per default as exception handler) */
void syscallExceptionHandler(ThreadId threadId);

/* Hardware exception handler (set per default as exception handler) */
void hwExceptionHandler();

/* branchDelayBit handler called directly in syscallExceptionHandler */
int branchDelayHandler( ThreadId fromId,       /* thread that caused exception */
		   Message* msgPtr,       /* message reference */
		   unsigned long int timeout,/* timeout for receiving */
		   MsgOpCode code);        /* SYSCALL_SEND_OP/SYSCALL_RECV_OP */

/* Automatic exit of a thread when stack underflow occurs */
void automaticThreadExit();
void endAutomaticThreadExit();

/* Symbols for the exception handlers (they are implemented in assembly) */
void UTLBMissHandler();
void endUTLBMissHandler();

void generalExceptionHandler();
void endGeneralExceptionHandler();

void msgAdjust(ThreadPtr pFromOrToThread, Message *msg, Boolean ToKernel);

void powerSaver();

#endif __TMHAL_H
