/*
    TMHalAsm.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/ia32/TMHalAsm.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:35 $      by: $Author: ruf $
	
	
	$Log: TMHalAsm.h,v $
	Revision 1.2  1999/12/13 21:48:35  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:51  jeker
	Initial revision
	
*/
#ifndef _TMHALASM_H_
#define _TMHALASM_H_


  /* Port Constants for i8259A (PIC: Programmable Interrupt Controller) */
  /* AT RefSpec defines two PICs PIC1, PIC2 */
#define PIC1_IO    0x20  /* IO Port for PIC1 */
#define PIC2_IO    0xA0  /* IO Port for PIC2 */
#define PIC1_MASK  0x21  /* Port for Masking IRQs 0x00..0x07 */
#define PIC2_MASK  0xA1  /* Port for Masking IRQs 0x08..0x0F */

  /* EOI */
#define EOI        0x20  /* reenable IRQs after IRQ n executed */

  /* Miscellaneous ports. */
#define PCR          0x65  /* Planar Control Register */
#define PORT_B       0x61  /* I/O port for 8255 port B (kbd, beeper...) */
#define TIMER0       0x40  /* I/O port for timer channel 0 */
#define TIMER2       0x42  /* I/O port for timer channel 2 */
#define TIMER_MODE   0x43  /* I/O port for timer mode control */

#ifndef __SASM__

/* irq.S */
void  __testIRQ();
void  __endOf_IRQ(unsigned char pIRQNo);
void  __enable_IRQ(unsigned char pIRQNo);
void  __disable_IRQ(unsigned char pIRQNo);

/* Exception Handling */
void __NEx_00();  /* Divide Error  -- division by zero         */
void __NEx_01();  /* Debug Exception                           */
void __NEx_02();  /* Nonmaskable Interrupt                     */
void __NEx_03();  /* Breakpoint (one byte INT 3 Instruction)   */
void __NEx_04();  /* Overflow (INTO)                           */
void __NEx_05();  /* Bounds check (BOUND)                      */
void __NEx_06();  /* Invalid Opcode                            */
void __NEx_07();  /* Coprocessor not available                 */
void __NEx_08();  /* Double fault (Error Code)                 */
void __NEx_09();  /* reserved                                  */
void __NEx_0A();  /* Invalid TSS (Error Code)                  */
void __NEx_0B();  /* Segment not present (Error Code)          */
void __NEx_0C();  /* Stack exception (Error Code)              */
void __NEx_0D();  /* General Protection (Error Code)           */
void __NEx_0E();  /* Page Fault (Error Code)                   */
void __NEx_0F();  /* reserved                                  */
void __NEx_10();  /* Coprocessor error                         */
void __NEx_11();  /* Alignment check (Error Code)              */
void __NEx_12();  /* Machine check (Error Code)                */

void __NEx_13();  /* reserved                                  */
void __NEx_14();  /* reserved                                  */
void __NEx_15();  /* reserved                                  */
void __NEx_16();  /* reserved                                  */
void __NEx_17();  /* reserved                                  */
void __NEx_18();  /* reserved                                  */
void __NEx_19();  /* reserved                                  */
void __NEx_1A();  /* reserved                                  */
void __NEx_1B();  /* reserved                                  */
void __NEx_1C();  /* reserved                                  */
void __NEx_1D();  /* reserved                                  */
void __NEx_1E();  /* reserved                                  */
void __NEx_1F();  /* reserved                                  */


/* IRQ-Handling */
void __NIR_00();  /* Timer */ 
void __NIR_01();  /* Keyboard */
void __NIR_02();  /* Cascade */
void __NIR_03();  /* Serial 2 */
void __NIR_04();  /* Serial 1 */
void __NIR_05(); 
void __NIR_06(); 
void __NIR_07(); 
void __NIR_08(); 
void __NIR_09();  /* Cascade */
void __NIR_0A(); 
void __NIR_0B(); 
void __NIR_0C(); 
void __NIR_0D(); 
void __NIR_0E(); 
void __NIR_0F(); 

void __INT_30();  /* Software Interrupt <-> SYSCALL */
void __INT_31();  /* Software Interrupt <-> BLOCKER */
#endif 

#endif
