/*
    TMError.c, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/ia32/TMError.c,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:34 $      by: $Author: ruf $
	
	
	$Log: TMError.c,v $
	Revision 1.2  1999/12/13 21:48:34  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:49  jeker
	Initial revision
	
*/
#include "TMError.h"
#include "Threads.h"
#include "Messages.h"
#include "TMHal.h"
#include "TMScheduler.h"

#include "Video.h"

  /* tmInstallErrorHandlers() is the point where the specialized Error Handlers
     could be initialized using
      tmInstallInterruptHandler() and 
      tmInstallExceptionHandler() 
     as defined in TMHal.c.
     
     I do not provide Installation of specialized ErrorHandlers, as Topsy v1.0
     does neither :-)
     
     Original Topsy Implementation installs at this point the ClockDriver 
     tmClockHandler(). I do not so, as the Clock Handler is not an Error Handler.
     
     I do provide an Installation of a Clock Handler in 
     TMHal.c/tmInstallExceptionCode().
   */
void tmInstallErrorHandlers(void) {
  /* I remove all ExceptionHandlers, as my default functionality provides more
     flexibility as the dummyExceptionHandler(). */
  int i ;
  for (i = 0; i < MAXNBOFEXCEPTIONS; i++)
    tmSetExceptionHandler(i,NULL);

  tmSetInterruptHandler(T_IR_00,tmClockHandler,NULL);
}

void tmError(ThreadId currentThread, char* errorString) {
    Message msg;
    
    msg.id = TM_KILL;
    msg.from = TMTHREADID;
    msg.msg.tmKill.id = currentThread;
    
    ERROR(errorString);
              
    /* immediate in-kernel delivery without syscall
     * kSend does a schedule after the message arrived
     */

    kSend(TMTHREADID, &msg); 
}

