/*
    TMClockAsm.S, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/ia32/TMClockAsm.S,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:34 $      by: $Author: ruf $
	
	
	$Log: TMClockAsm.S,v $
	Revision 1.2  1999/12/13 21:48:34  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:48  jeker
	Initial revision
	
*/
#include "asm.h"                /* Macros */

#define __SASM__
#include "TMHalAsm.h"
#undef  __SASM__


.section .sasm
.align 4,0x9090

// void _timerSet(ushort pDIVISOR);
/* void _timerSet(unsigned short pDIVISOR, 
                  unsigned char  pCtrlWord,
                  unsigned char  pTimerChannel); */
FRAME(__timerSet)
        ENTER
        pushl   %eax
        pushl   %edx
        
        /*
        // binary, mode 2, LSB/MSB, ch 0
        // Write Counter 0,     Write LSB+MSB,  Mode 2, Binary Coded Value
        //      00              11              010     0 
        // =>   = 00110100b = 0x34 
        movl    $0x34,%eax 
        outb    %al,$0x43 */
        
        movl    ARG2,%eax               /* Control Word */
        outb    %al,$TIMER_MODE         /* Write Control Port */

        jmp     _timerSetn1             /* let bus settle */
_timerSetn1:

        movl    ARG3,%edx               /* get the channel to write */

        /* send LSB */
        movl    ARG1,%eax
        outb    %al,%dx

        jmp     _timerSetn2             /* let bus settle */
_timerSetn2:

        // send MSB
        movb    %ah,%al
        outb    %al,%dx
        
        popl    %edx
        popl    %eax
        LEAVE

/* Below this point there are general support functions */      
////
// ulong _get8254V();
FRAME(__get8254V)
        ENTER
        pushl   %ebx

        xorl    %ebx,%ebx
        
        // 11100010b = 226 = 0xE2
        movl    $0xE2,%eax
        outb    %al,$0x43               // return STATE of Channel 0
        inb     $0x40,%al
        shll    $16,%eax

        movb    $0x00,%al
        outb    %al,$0x43               // return DIVISOR in locked LATCH
        inb     $0x40,%al               // get LSB
        movb    %al,%bl
        inb     $0x40,%al               // get MSB
        movb    %al,%ah
        movb    %bl,%al
        
        popl    %ebx
        LEAVE


__settle:
        jmp     _settlen1
_settlen1:
        ret
        
////
// uchar _readRTC(uchar pBYTEtoREAD);
FRAME(__readRTC)
        ENTER
        pushfl  
        cli
        xorl    %eax,%eax
        movl    8(%ebp),%eax
        outb    %al,$0x70
        call    __settle
        inb     $0x71,%al
        popfl
        LEAVE

////
// void _writeRTC(uchar pBYTEtoWRITE, uchar pVALUEtoWRITE);
FRAME(__writeRTC)
        ENTER
        pushfl
        cli
        pushl   %eax
        movl    8(%ebp),%eax
        outb    %al,$0x70
        call    __settle
        movl    12(%ebp),%eax
        outb    %al,$0x71
        popl    %eax
        popfl   
        LEAVE
        
////
// ulong _tryForPS2();
// Return state of F,E,D,C Ctrl Bytes
FRAME(__tryForPS2)
        pushl   %ebx
        xorl    %ebx,%ebx
        
        pushl   $0x0F
        call    __readRTC
        addl    $4,%esp
        movb    %al,%bh
        
        pushl   $0x0E
        call    __readRTC
        addl    $4,%esp
        movb    %al,%bl
        
        shll    $16,%ebx
        
        pushl   $0x0D
        call    __readRTC
        addl    $4,%esp
        movb    %al,%bh
        
        pushl   $0x0C
        call    __readRTC
        addl    $4,%esp
        movb    %al,%bl

        movl    %ebx,%eax
        popl    %ebx
        ret

