/*
    Threads.h, Copyright  (c) by Christian Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/Threads.h,v $
 	Author(s):             Christian Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.32 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:34 $      by: $Author: ruf $
	
	
	$Log: Threads.h,v $
	Revision 1.32  1999/12/13 21:48:34  ruf
	GNU General Public Licence Update
	
	Revision 1.31  1999/01/14 18:40:06  cjeker
	threadStart and threadBuild have now one more argument: priority
	
	Revision 1.30  1997/04/07 13:03:06  gfa
	adjusted IOTHREADID
	
 * Revision 1.29  1997/04/07  12:14:03  gfa
 * rcs trouble on sun...
 *
 * Revision 1.28  1997/04/07  10:20:43  gfa
 * changed FIRST_KERNELTHREAD to  (IOTHREADID-1)
 *
 * Revision 1.27  97/04/06  18:54:54  gfa
 * source cleanup and change to tmExit (added vmCleanup)
 * 
 * Revision 1.26  97/03/31  20:34:58  gfa
 * *** empty log message ***
 * 
 * Revision 1.25  1997/03/28  12:17:00  gfa
 * *** empty log message ***
 *
 * Revision 1.24  1997/03/27  13:54:50  conrad
 * interrupts moved to exception.h
 *
 * Revision 1.23  1997/03/24  20:30:25  gfa
 * *** empty log message ***
 *
 * Revision 1.22  1997/03/24  11:03:33  conrad
 * stack size moved to Configuration.h
 *
 * Revision 1.21  1997/03/22  14:30:45  conrad
 * locks replace msg for heap
 *
 * Revision 1.20  1997/03/21  13:02:49  conrad
 * *** empty log message ***
 *
 * Revision 1.19  1997/03/20  14:02:52  conrad
 * THREAD_MODE checks with threadId 0, not with MMTHREADID
 *
 * Revision 1.18  1997/03/18  16:30:06  conrad
 * Adding of software interrups 0 and 1
 *
 * Revision 1.17  1997/03/16  22:11:46  gfa
 * *** empty log message ***
 *
 * Revision 1.16  1997/03/13  18:33:21  gfa
 * added THREAD_MODE macro
 *
 * Revision 1.15  1997/03/13  10:34:06  gfa
 * set correct values for exception/interrupt numbers
 *
 * Revision 1.14  1997/03/12  18:52:20  gfa
 * changed CLOCK0 to CLOCKINT_0
 *
 * Revision 1.13  1997/03/11  20:07:06  conrad
 * First version to be debugged with Simulator
 *
 * Revision 1.12  1997/03/10  11:29:38  conrad
 * Adding of hmStack parameter to tmInit
 *
 * Revision 1.11  1997/03/09  20:46:33  gfa
 * *** empty log message ***
 *
 * Revision 1.10  1997/03/06  16:15:24  conrad
 * Adding of #include "Error.h"
 *
 * Revision 1.9  1997/02/21  16:52:29  conrad
 * very incomplete status due to major changes ...
 *
 * Revision 1.8  1997/02/21  09:15:13  conrad
 * Intermediate status (not yet completed)
 *
 * Revision 1.7  1997/02/19  17:46:24  conrad
 * *** empty log message ***
 *
 * Revision 1.6  1997/02/18  18:28:04  conrad
 * Introduction of tm-include.h
 *
 * Revision 1.5  1997/02/18  17:25:37  conrad
 * *** empty log message ***
 *
 * Revision 1.4  1997/02/14  11:28:46  zitzler
 * ThreadArg type moved to Topsy.h
 *
 * Revision 1.3  1997/02/13  15:44:51  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.2  1997/02/13  07:52:15  conrad
 * Syscalls moved to Topsy/Syscall.h
 *
 * Revision 1.1  1997/02/12  15:33:41  conrad
 * Initial revision
 *
 * Revision 1.1  1997/02/04  11:43:41  topsy
 * Initial revision
 *
*/
#ifndef __THREADS_H
#define __THREADS_H

#include "Topsy.h"
#include "Messages.h"
#include "Error.h"
#include "Exception.h"

#define FIRST_USERTHREAD 2
#define FIRST_KERNELTHREAD IOTHREADID /* besides mm, tm, io */

/* MM thread is *really* the first one (id -1) */
/* this macro makes invalid id's USER          */
#define THREAD_MODE(x) (x <= MMTHREADID ? KERNEL : USER)

/* MM thread is *really* the first one (id -1) */
/* this macro makes invalid id's USER_PRIORITY */
#define THREAD_PRIORITY(x) (x <= MMTHREADID ? KERNEL_PRIORITY : USER_PRIORITY)

/*
 * Exported data types
 */
typedef void (*ExceptionHandler)(ThreadId id);
typedef void (*InterruptHandler)(void* arg);

/*
 * These functions may only be invoked inside kernel
 */
Error kSend( ThreadId dest,
	     Message *msg);
InterruptHandler tmSetInterruptHandler( InterruptId id, 
					InterruptHandler intHdler, void* arg);
ExceptionHandler tmSetExceptionHandler( ExceptionId id, 
					ExceptionHandler excHdler);
/*
 * Init and Main procedures
 */
void tmInit( Address mmStack,
	     Address tmStack,
	     Address userInit);

void tmMain( ThreadArg userInitAddress);

/* Initialisation of basic exception handlers for init phase */
void initBasicExceptions();

char* getCurrentThreadName();

#endif __THREADS_H
