/*
    Copyright 2000 (c) by Reto Gaehler, George Fankhauser
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/TMTimer.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:40 $      by: $Author: gfa $


    $Log: TMTimer.h,v $
    Revision 1.1  2000/03/31 17:50:40  gfa
    Merged with /Net from several term projects

*/
#ifndef __TMTIMER_H
#define __TMTIMER_H

#include <Topsy.h>
#include <Syscall.h>

//**************************************************************************************************
//	definitions
//**************************************************************************************************

#define TIMER_FAILED			-1
#define TIMER_OK				1
#define TIMER_GRANULARITY		10		//ms

#define TIMER_MAX_EVENTS		20

typedef void (*tmCallBackProc)(void *pParam,long n32Param,void *pMsg1,void *pMsg2,unsigned long u32Msg);

//**************************************************************************************************
//	type definitions
//**************************************************************************************************

/* A timer delta list entry */

typedef struct tqent {
	long int		tq_entrytime;			/* time when inserted in queue	*/
	int				tq_timeleft;			/* time to expire (1/100 secs)	*/
	int				tq_interval;		
	tmCallBackProc	tq_fire;       			/* will be executed as soon as a timer expires */
	void			*tq_pParam;				/* param 1 to send when expired	*/
	long			tq_n32Param;			/* param 2 to send when expired	*/
	void			*tq_pMsg1;				/* data 1 to send when expired	*/
	void			*tq_pMsg2;				/* data 2 to send when expired	*/
	unsigned long	tq_u32Msg;				/* user parameter send when expired	*/
	struct	tqent	*tq_next;				/* next in the list	*/
} tqent, *tqentptr;

//**************************************************************************************************
//	module interface
//**************************************************************************************************

//**************************************************************************************************
//	tmTimerInit
//**************************************************************************************************
void tmTimerInit();

//**************************************************************************************************
//	tmGetTickCount
//**************************************************************************************************
long int tmGetTickCount();

//**************************************************************************************************
//	tmTimerInterrupt
//	timer interrupt service routine (called every 10ms)
//**************************************************************************************************
void tmTimerInterrupt();

//**************************************************************************************************
//	tmLeftTimer
//	returns the remaining time of a timer queue element
//**************************************************************************************************
int tmLeftTimer(tmCallBackProc fire,void *pParam, long n32Param,
					void *pMsg1,void *pMsg2,unsigned long u32Msg);

//**************************************************************************************************
//	tmClearTimer
//	removes a timer queue element
//**************************************************************************************************
int tmClearTimer(	tmCallBackProc fire,void *pParam, long n32Param,
					void *pMsg1,void *pMsg2,unsigned long u32Msg);

//**************************************************************************************************
//	tmSetTimer
//	inserts a timer queue element
//**************************************************************************************************
int tmSetTimer(	tmCallBackProc fire, void *pParam, long n32Param,
				void *pMsg1,void *pMsg2,unsigned long u32Msg,int time,Boolean bRepeat);


#endif __TMTIMER_H
