/*
    TMTime.c, Copyright  (c) by ,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/TMTime.c,v $
 	Author(s):             
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.4 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:34 $      by: $Author: ruf $
	
	
	$Log: TMTime.c,v $
	Revision 1.4  1999/12/13 21:48:34  ruf
	GNU General Public Licence Update
	
	Revision 1.3  1999/01/08 22:24:55  cjeker
	even more bug fixes
	
	Revision 1.2  1999/01/06 17:47:35  cjeker
	code cleaning
	
	Revision 1.1  1998/10/19 08:15:53  topsy
	Initial revision
	
*/

#include "TMClock.h"
#include "Configuration.h"

/* that's what is being used as a counter */
static unsigned long tmTimeTicks;


/* this procedure is periodically called by the clock interrupt handler 
 */
void tmTimeUpdate()
{
    tmTimeTicks++;
}

/* this is a simple init for time. if there is an RTC with battery the 
 * ticks should be initialized by the RTC's value
 */
void tmTimeInit()
{
    tmTimeTicks = tmRTClockGetSeconds() * (1000 / TIMESLICE);
}

Error tmTimeGet(unsigned long* seconds, unsigned long* microSeconds)
{
    *seconds = tmTimeTicks / (1000 / TIMESLICE);
    *microSeconds = (tmTimeTicks % (1000 / TIMESLICE)) * (1000 * TIMESLICE);

    return TM_OK;
}


Error tmTimeSet(unsigned long seconds, unsigned long microSeconds)
{
    tmRTClockSetSeconds(seconds, microSeconds);
    tmTimeTicks = seconds * (1000 / TIMESLICE);
    tmTimeTicks += microSeconds * 1000000 / (1000 / TIMESLICE);

    return TM_OK;
}
