/*
    TMThread.h, Copyright  (c) by Christian Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/TMThread.h,v $
 	Author(s):             Christian Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.18 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:34 $      by: $Author: ruf $
	
	
	$Log: TMThread.h,v $
	Revision 1.18  1999/12/13 21:48:34  ruf
	GNU General Public Licence Update
	
	Revision 1.17  1999/01/14 18:40:06  cjeker
	threadStart and threadBuild have now one more argument: priority
	
	Revision 1.16  1999/01/07 16:15:55  cjeker
	removed lightWeight Threads and added new syscall tmGetIDInfo
	
	Revision 1.15  1998/03/26 20:35:52  gfa
	added getFirst/getNext to threadInfo
	
	Revision 1.14  1997/04/23 09:04:54  gfa
	formatting

 * Revision 1.13  1997/04/13  17:01:19  conrad
 * no longer startMinimalThread(), standard use of threadBuild() instead
 *
 * Revision 1.12  1997/04/09  16:22:53  conrad
 * *** empty log message ***
 *
 * Revision 1.11  1997/03/31  20:32:36  gfa
 * moved almost all register accesses to TMHal and used functions here
 * also adapted this module to the changes in scheduler.
 *
 * Revision 1.10  1997/03/28  12:38:06  conrad
 * adding of TM_INFO
 *
 * Revision 1.9  1997/03/21  20:01:53  conrad
 * new idle thread
 *
 * Revision 1.8  1997/03/20  10:35:22  conrad
 * threadBuild() removes threadStartStatic (for consistency reasons)
 *
 * Revision 1.7  1997/03/09  20:43:56  gfa
 * *** empty log message ***
 *
 * Revision 1.6  1997/02/21  16:52:29  conrad
 * very incomplete status due to major changes ...
 *
 * Revision 1.5  1997/02/21  09:15:13  conrad
 * Intermediate status (not yet completed)
 *
 * Revision 1.4  1997/02/18  18:28:04  conrad
 * Introduction of tm-include.h
 *
 * Revision 1.3  1997/02/18  17:25:37  conrad
 * *** empty log message ***
 *
 * Revision 1.2  1997/02/13  15:44:51  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.1  1997/02/12  15:35:07  conrad
 * Initial revision
 *
*/

#ifndef __TMTHREAD_H
#define __TMTHREAD_H

#include "tm-include.h"
#include "Lock.h"

extern Lock threadLock;

/*
 * Thread interface functions
 */
ThreadId threadStart( ThreadMainFunction fctnAddr, 
		      ThreadArg parameter,
		      AddressSpace mode,
		      char *name,
		      ThreadId parentId,
		      ThreadPriority priority);
void threadExit( ThreadId threadId);
void threadYield();
Error threadKill( ThreadId id, ThreadId killerId);
Error threadInfo( ThreadId id, ThreadId aboutId,
		  ThreadInfoKind kind, ThreadInfo* infoptr, long int values[]);

void threadBuild( ThreadId id,
		  ThreadId parentId,
		  char* name,
		  ProcContextPtr contextPtr,
		  Address stackBaseAddress,
		  unsigned int stackSize,
		  ThreadMainFunction mainFunction,
		  ThreadArg parameter,
		  AddressSpace space,
		  Thread* threadPtr,
		  ThreadPriority priority);

ThreadId startMinimalIdleThread();

#endif __TMTHREAD_H
