/*
    TMScheduler.h, Copyright  (c) by Christian Conrad & George,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/TMScheduler.h,v $
 	Author(s):             Christian Conrad & George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.10 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:33 $      by: $Author: ruf $
	
	
	$Log: TMScheduler.h,v $
	Revision 1.10  1999/12/13 21:48:33  ruf
	GNU General Public Licence Update
	
	Revision 1.9  1997/03/31 20:30:42  gfa
	minor redesign, uses a symmetric structure (ready/blocked queues) and
	leaves the running thread in the ready queue (saves some headache).
	uses new efficient and memory free list ops.
	
 * Revision 1.8  1997/03/21  20:01:53  conrad
 * new idle thread
 *
 * Revision 1.7  1997/03/21  13:02:49  conrad
 * adding of an idleCProcedure for testing
 *
 * Revision 1.6  1997/03/11  20:07:06  conrad
 * First version to be debugged with Simulator
 *
 * Revision 1.5  1997/03/04  16:56:01  conrad
 * minor changes
 *
 * Revision 1.4  1997/02/18  18:28:04  conrad
 * Introduction of tm-include.h
 *
 * Revision 1.3  1997/02/18  17:25:37  conrad
 * *** empty log message ***
 *
 * Revision 1.2  1997/02/13  15:44:51  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.1  1997/02/12  15:35:07  conrad
 * Initial revision
 *
*/

#ifndef __TMSCHEDULER_H
#define __TMSCHEDULER_H

#include "tm-include.h"

/*
 * Scheduler interface functions (used by the thread manager)
 */
void schedulerInit(Thread* threadPtr);
void schedulerInsert( Thread* threadPtr, ThreadPriority priority);
void schedulerRemove( Thread* threadPtr);

Error schedulerSetReady( Thread* threadPtr);
Error schedulerSetBlocked( Thread* threadPtr);
Thread* schedulerRunning();
void schedule();

/* Clock interrupt handler and idle thread main function */
void tmClockHandler();
void tmIdleMain();

#endif __TMSCHEDULER_H
