/*
    TMInit.c, Copyright  (c) by Christian Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/TMInit.c,v $
 	Author(s):             Christian Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.41 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:33 $      by: $Author: ruf $
	
	
	$Log: TMInit.c,v $
	Revision 1.41  1999/12/13 21:48:33  ruf
	GNU General Public Licence Update
	
	Revision 1.40  1999/10/29 08:25:39  jeker
	*** empty log message ***
	
	Revision 1.39  1999/10/19 14:59:02  gfa
	*** empty log message ***

	Revision 1.38  1999/04/08 11:40:15  jeker
	added some new files, modified some others for unix port

	Revision 1.37  1999/02/02 23:04:02  cjeker
	latest fixes

	Revision 1.36  1999/01/07 16:15:54  cjeker
	removed lightWeight Threads and added new syscall tmGetIDInfo
	
	Revision 1.35  1997/04/23 09:06:36  gfa
	adjusted comments
	
 * Revision 1.34  1997/04/09  16:22:36  conrad
 * *** empty log message ***
 *
 * Revision 1.33  1997/04/08  20:38:09  conrad
 * include of TMError.h
 *
 * Revision 1.32  1997/04/08  20:21:15  conrad
 * adding of tmInstallErrorHandlers()
 *
 * Revision 1.31  1997/04/07  11:32:17  gfa
 * changed for new tmSetInterruptHandler interface (added NULL arg)
 *
 * Revision 1.30  97/03/31  20:34:22  gfa
 * moved exception handler code copying to tmhal
 * 
 * Revision 1.29  1997/03/27  17:27:46  gfa
 * changed list usage to hinting lists
 *
 * Revision 1.28  1997/03/24  20:29:41  gfa
 * changed thread startup to use simple newList and newHashList
 *
 * Revision 1.27  1997/03/23  12:40:19  gfa
 * moved TIMESLICE to Configuaration.h
 *
 * Revision 1.26  97/03/22  14:31:12  conrad
 * locks replace msg for heap
 * 
 * Revision 1.25  1997/03/21  19:29:19  conrad
 * Prepared for introducing an idle thread
 *
 * Revision 1.24  1997/03/21  16:13:23  conrad
 * changed restoreContext() to check if a new threadPtr is NULL, if yes, restore
 * of a 'fake' idle context
 *
 * Revision 1.23  1997/03/21  13:54:54  conrad
 * *** empty log message ***
 *
 * Revision 1.22  1997/03/20  10:34:51  conrad
 * threadBuild() removes threadStartStatic (for consistency reasons)
 *
 * Revision 1.21  1997/03/19  21:37:00  conrad
 * added a global linear list for all threads
 * fixed bug with stackStart and stackEnd (total confusion ...)
 *
 * Revision 1.20  1997/03/18  17:43:02  conrad
 * Adding of #include "TMClock.h"
 *
 * Revision 1.19  1997/03/18  16:28:04  conrad
 * fixed statusRegister
 *
 * Revision 1.18  1997/03/16  22:12:59  gfa
 * *** empty log message ***
 *
 * Revision 1.17  1997/03/13  11:45:50  conrad
 * Using of constants SR_IEp instead of 0x00000004
 *
 * Revision 1.16  1997/03/12  18:49:47  gfa
 * fixed CLOCK0 to CLOCKINT_0
 *
 * Revision 1.15  1997/03/12  17:53:48  conrad
 * Debugging version
 *
 * Revision 1.14  1997/03/11  20:07:06  conrad
 * First version to be debugged with Simulator
 *
 * Revision 1.13  1997/03/11  08:19:23  gfa
 * *** empty log message ***
 *
 * Revision 1.12  1997/03/10  15:28:57  conrad
 * *** empty log message ***
 *
 * Revision 1.11  1997/03/10  11:30:05  conrad
 * Adding of hmStack parameter to tmInit
 *
 * Revision 1.10  1997/03/09  20:44:16  gfa
 * *** empty log message ***
 *
 * Revision 1.9  1997/03/07  13:00:38  conrad
 * Adding Error module
 *
 * Revision 1.8  1997/03/04  16:56:01  conrad
 * minor changes
 *
 * Revision 1.7  1997/02/27  14:38:08  conrad
 * minor changes
 *
 * Revision 1.6  1997/02/26  17:34:02  conrad
 * cleaning
 *
 * Revision 1.5  1997/02/25  16:58:14  conrad
 * Writing of tmInit() first code ...
 *
 * Revision 1.4  1997/02/21  16:52:29  conrad
 * very incomplete status due to major changes ...
 *
 * Revision 1.3  1997/02/21  09:15:13  conrad
 * Intermediate status (not yet completed)
 *
 * Revision 1.2  1997/02/19  17:46:24  conrad
 * *** empty log message ***
 *
 * Revision 1.1  1997/02/12  15:35:07  conrad
 * Initial revision
 *
 * Revision 1.1  1997/02/04  11:43:36  topsy
 * Initial revision
 *
*/

#include "Topsy.h"
#include "TMHal.h"
#include "TMInit.h"
#include "TMClock.h"
#include "HashList.h"
#include "List.h"
#include "Support.h"
#include "Threads.h"
#include "TMIPC.h"
#include "TMScheduler.h"
#include "TMThread.h"
#include "TMError.h"

/* Global variables */
List threadList;                  /* Contains all threads (user & kernel) */
extern HashList threadHashList;   /* Hash list of all threads */
extern Scheduler scheduler;       /* Scheduler structure */

/* Statically allocated thread structures for tm and mm */
Thread mmThread, tmThread;
ProcContext mmContext, tmContext;

void dummyExceptionHandler(ThreadId id)
{
    WARNING("No exception handler has been set yet");
}

void dummyInterruptHandler()
{
    WARNING("No interrupt handler has been set yet");
}

void initBasicExceptions()
{
    int i;
    
    /* setup the exception and interrupt handling at its correct place.
     * this is highly machine dependent (vectorized exceptions vs. software
     * dispatch (as on the mips).
     */
    tmInstallExceptionCode();
	
    /* Initialization of default dummy exception handlers */
    for (i = 0; i < MAXNBOFEXCEPTIONS; i++) {
	tmSetExceptionHandler(i, dummyExceptionHandler);
    }
    for (i = 0; i < MAXNBOFINTERRUPTS; i++) {
	tmSetInterruptHandler(i, dummyInterruptHandler, NULL);
    }
}


void tmInit( Address mmStack, Address tmStack, Address userInit)
{
    /* Initialisation of the scheduler data structures.
     * The first thread is passed as argument.
     */
    schedulerInit(&tmThread);
    lockInit(threadLock);
    
    /* build mm and tm threads */
    threadBuild( MMTHREADID, 0, "mmThread", &mmContext,
		 mmStack, TM_DEFAULTTHREADSTACKSIZE,
		 mmMain, (ThreadArg)0, KERNEL,&mmThread, KERNEL_PRIORITY);
    threadBuild( TMTHREADID, 0, "tmThread", &tmContext,
		 tmStack, TM_DEFAULTTHREADSTACKSIZE,
		 tmMain, (ThreadArg)userInit, KERNEL, &tmThread, KERNEL_PRIORITY);

    /* Store pointer to mm and tm in threadHashList hash table */
    threadHashList = hashListNew();
    hashListAdd(threadHashList, &mmThread, mmThread.id);
    hashListAdd(threadHashList, &tmThread, tmThread.id);

    /* add mm and tm to threadList */
    threadList = listNew();
    listAddInFront(threadList, &mmThread, NULL);
    listAddInFront(threadList, &tmThread, NULL);
    
    /* Setting of default handlers for SYSCALL and Hardware exceptions */
    tmInstallErrorHandlers();

    /* Threads mm and tm are set to ready status, scheduling decision */
    schedulerSetReady(&mmThread);
    schedulerSetReady(&tmThread);
    schedule();					/* first thread is picked */

    /* Clock configuration */
    if (PREEMPTIVE_MODE) {
		if (setClockValue(CLOCK0, TIMESLICE, RATEGENERATOR) != TM_OK) {
		    PANIC("Clock could not be properly configured");
		}
    }

    restoreContext(scheduler.running->contextPtr);
    /*** initialization of the kernel ends here, from this point 
     *** we run in kernel mode with interrupts enabled.
     *** now this is the real thing (tm)...
     ***/
}
