/*
    TMIPC.h, Copyright  (c) by Christian Conrad,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
 	PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Threads/TMIPC.h,v $
 	Author(s):             Christian Conrad
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.19 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:33 $      by: $Author: ruf $
	
	
	$Log: TMIPC.h,v $
	Revision 1.19  1999/12/13 21:48:33  ruf
	GNU General Public Licence Update
	
	Revision 1.18  1999/01/08 21:28:01  cjeker
	moved branchDelayBit handling to TMHalAsm.S
	
	Revision 1.17  1997/04/23 09:04:54  gfa
	formatting
	
 * Revision 1.16  1997/04/21  07:25:01  conrad
 * cleanup
 *
 * Revision 1.15  1997/04/06  18:56:33  gfa
 * adjusted calls to TMHal
 *
 * Revision 1.14  1997/04/01  16:23:31  conrad
 * *** empty log message ***
 *
 * Revision 1.13  1997/03/31  20:30:08  gfa
 * changed calls to ready/blocked
 * and schedule()
 *
 * Revision 1.12  1997/03/20  14:01:33  conrad
 * Adding of the freeBlockedThreads() function
 *
 * Revision 1.11  1997/03/13  14:25:02  conrad
 * Simplification of the pending structure
 * Introduction of three states for pending buffer (2 were not sufficient)
 *
 * Revision 1.10  1997/03/12  17:53:48  conrad
 * Debugging version
 *
 * Revision 1.9  1997/03/04  16:56:01  conrad
 * minor changes
 *
 * Revision 1.8  1997/02/26  17:34:02  conrad
 * cleaning
 *
 * Revision 1.7  1997/02/25  16:58:14  conrad
 * *** empty log message ***
 *
 * Revision 1.6  1997/02/24  21:35:02  conrad
 * incomplete version
 *
 * Revision 1.5  1997/02/21  16:52:29  conrad
 * very incomplete status due to major changes ...
 *
 * Revision 1.4  1997/02/18  18:28:04  conrad
 * Introduction of tm-include.h
 *
 * Revision 1.3  1997/02/18  17:25:37  conrad
 * *** empty log message ***
 *
 * Revision 1.2  1997/02/13  15:44:51  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.1  1997/02/12  15:35:07  conrad
 * Initial revision
 *
*/

#ifndef __TMIPC_H
#define __TMIPC_H

#include "tm-include.h"

/*
 * IPC interface functions
 */
Error kRecv(Message *msg, Thread* threadPtr);
Error kSend(ThreadId destThreadId, Message* msgPtr);

/* Invoked by the general exception routine to process SYSCALLS */
int msgDispatcher( ThreadId dummyThreadid,    /* not used */
		   Message* msgPtr,           /* message reference */
		   unsigned long int timeout, /* timeout for receiving */
		   MsgOpCode code);           /* SYSCALL_SEND_OP/SYSCALL_RECV_OP */

/* Initialisation of the message queue */
void initMsgQueue( MessageQueue* queuePtr);

void ipcResetPendingFlag(Thread* threadPtr);
void ipcFreeBlockedThreads( ThreadId exitThreadId);

#endif __TMIPC_H
