/*
    start.S, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Startup/mips/start.S,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.12 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:33 $      by: $Author: ruf $
	
	
	$Log: start.S,v $
	Revision 1.12  1999/12/13 21:48:33  ruf
	GNU General Public Licence Update
	
	Revision 1.11  1999/04/08 11:40:14  jeker
	added some new files, modified some others for unix port
	
	Revision 1.10  1999/01/06 17:47:35  cjeker
	code cleaning

	Revision 1.9  1998/06/09 17:45:59  gfa
	added __main()
	
	Revision 1.8  1997/04/23 09:02:17  gfa
	formatting

# Revision 1.7  1997/04/21  07:24:50  conrad
# cleanup
#
# Revision 1.6  1997/04/07  07:47:25  gfa
# moved __main to hardware independent part
#
# Revision 1.5  97/03/12  17:56:53  conrad
# debugging version
# 
# Revision 1.4  1997/03/10  19:19:29  gfa
# name change BOOTSTACKTOP
#
# Revision 1.3  1997/02/26  19:27:55  gfa
# *** empty log message ***
#
# Revision 1.2  1997/02/26  19:09:05  gfa
# *** empty log message ***
#
# Revision 1.1  1997/02/04  11:42:16  topsy
# Initial revision
#
*/

#include "asm.h"
#include "cpu.h"
#include "MemoryLayout.h"

	.text
	.align  2

/* __start: the starting point, the address where the EPROM loader or
 * the simulator jumps to 
 */
    FRAME(__start)
    
	la		gp, 0x80000000 	    /*_gp, value of global pointer */
  	la		sp, BOOTSTACKTOP    /* prepare bootstack */
        move            fp, sp
	subu	        sp, sp, 32
	sw		ra, 28(sp)
	sw		fp, 24(sp)


	mtc0		zero, c0_status	 /* disable interrupts, kernel mode */
	jal		StartMeFirst
	nop
	    
    END(__start)

    FRAME(__main)
    END(__main)

