/*
    StartMeFirst.c, Copyright 1999 (c) by Claudio Jeker,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Startup/mips/StartMeFirst.c,v $
        Author(s):             Claudio Jeker
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.6 $
        Creation Date:         1999/04/08
        Last Date of Change:   $Date: 1999/12/13 21:48:32 $      by: $Author: ruf $
        
        
        $Log: StartMeFirst.c,v $
        Revision 1.6  1999/12/13 21:48:32  ruf
        GNU General Public Licence Update

        Revision 1.5  1999/10/29 15:19:30  jeker
        *** empty log message ***

        Revision 1.4  1999/10/28 21:21:56  jeker
        hack to get R3k and R4k running

        Revision 1.3  1999/10/27 19:07:46  jeker
        fixes for R3k R4k port (restoreContext)

        Revision 1.2  1999/05/13 17:05:46  jeker
        Initial revision

        Revision 1.1  1999/04/08 11:40:13  jeker
        added some new files, modified some others for unix port

*/

#include "Startup.h"
#include "Memory.h"
#include "MemoryLayout.h"
#include "MMMapping.h"
#include "TMHal.h"
#include "SupportMIPS.h"

/* this is a dummy function to initalize the segmap Pointer etc.
   SEGMAP is defined in the Makefile. Only so it is arch clean */


SegMapPtr segmap;

void StartMeFirst()
{
	segmap = (SegMapPtr) SEGMAP;
	bootStackBottom = BOOTSTACKBOTTOM;

	if( getPRID() == PRID_R3k ) {
		restoreContext = restoreContext_R3k;
	} else {
		restoreContext = restoreContext_R4k;
	}	

	topsyMain();
}

