/*
    start.S, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Startup/ia32/start.S,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:32 $      by: $Author: ruf $
	
	
	$Log: start.S,v $
	Revision 1.2  1999/12/13 21:48:32  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:46  jeker
	Initial revision
	
*/
#include "MemoryLayout.h"
#include "asm.h"

#define TRACKMAX        64512

.extern __printstr

.section .init
.align  4,0x9090
.org    0x00000000

// even if all is already defined in CoreLoad.BIN
// we set the defaults for sure
        
marker:
        .asciz  "TOPSYi386"     // MARKER for PATCHING
        .org 0x10
_tracktoread:
        nop
        nop
        nop
        nop
_textsize:
        nop             // Save Space for Patching Size of
        nop             // TEXT ( starting at offset 0)
        nop             // DATA ( page aligned )
        nop             // i.e. first  the SIZE of TEXT is patched into
_datasize:      
        nop             //      second the SIZE of DATA is patched into
        nop             // the starting address of DATA is PAGE ALIGNED !!
        nop
        nop
        
        .org    0x40    // make sure there is enough room for information storage
        .align  4,0x9090
        
FRAME(__start)
        nop             // make sure, the disassembler is able to synchronize...
        nop             // this is only inserted here, as all disassemblers
        nop             // to not really know about -- how could they... 
        nop             // this would not be used for execution but for readability,
        nop             // I'm still human :-)
        nop
        nop
        nop
        movl    $gcKDSEL,%eax
        movw    %ax,%ds
        movw    %ax,%es
        movw    %ax,%fs
        movw    %ax,%gs
        movw    %ax,%ss

        movl    $BOOTSTACKTOP,%eax      
        movl    %eax,%esp       

/*
  CONCATENATION: PM, Kernel is executing lowest level of startup
  In Assembler only concatenating of Kernel chunk of bytes is performed.
  All other concatenation is done during Initialization running 
  full C-Code.
  Therefore, this code has to be concatenated... I do not like parsing the
  Code segment. So, bruteforce: Concatenate in Assembler and Execute as normal.
 */
store_patched_values:   
        movl    _tracktoread,%eax       // save in register
        movl    %eax,_ltracks           // save in data segment
        
        movl    _textsize,%eax          // save on stack
        movl    %eax,_ltexts            // save in data segment

        movl    _datasize,%eax          // .... and
        movl    %eax,_ldatas            // save in data segment

// now, try to say hello 
        
        movl    $success,%eax
        pushl   %eax
        movl    $0x1F,%eax
        pushl   %eax
        movl    lsuccOfs,%eax
        pushl   %eax
        call    __printstr
        addl    $12,%esp
        
        movl    $copyrights,%eax
        pushl   %eax
        movl    $0x1F,%eax
        pushl   %eax
        movl    lcopyOfs,%eax
        pushl   %eax
        call    __printstr
        addl    $12,%esp
        
        call    __stop_fd               // Turn off floppy drive

        jmp     main                    // and now GO !!


//****************************************************************************//
//***  Support Functions to report correct "sizes"                         ***//
//****************************************************************************//
        .section .sasm
        .align  4,0x9090
//ulong __getTextSize();        
// return size of .text as pachted by KernelPatch 
FRAME(__getTextSize)
        ENTER
        movl    _ltexts,%eax
        LEAVE

//ulong __getDataSize();        
// return size of .data as pachted by KernelPatch 
FRAME(__getDataSize)
        ENTER
        movl    _ldatas,%eax
        LEAVE

//ulong __getKernelSize();      
// return size of .data as pachted by KernelPatch 
FRAME(__getNoOfTracks)
        ENTER
        movl    _ltracks,%eax
        LEAVE

//stop floppy disk light :-)    
FRAME(__stop_fd)
        pushl   %eax
        pushl   %edx
        movl    $0x3F2,%edx     // Floppy Port
        xorb    %al,%al         // Turn of Floppy
        outb    %al,%dx
        popl    %edx
        popl    %eax
        ret

//****************************************************************************//
//***  Startup Messages (just to say "I'm alive"                           ***//
//****************************************************************************//

        .data
        .align  4,0x9090
success:
        .asciz  " => successfully completed."
        
copyrights:
        .asciz  "==> Topsy i386, Kernel Startup 0.113 Lukas Ruf June 1998 <=="

lsuccOfs:
        .long   0x00000D56 

lcopyOfs:
        .long   0x00000DC0

_ltexts:
        .long   0x00000000
_ldatas:
        .long   0X00000000
_ltracks:
        .long   0X00000000
        

