/*
    BinaryFile.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Startup/ia32/BinaryFile.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:32 $      by: $Author: ruf $
	
	
	$Log: BinaryFile.h,v $
	Revision 1.2  1999/12/13 21:48:32  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:44  jeker
	Initial revision
	
*/
#ifndef __BINFILE_H__
#define __BINFILE_H__

typedef struct BinaryFileDesc_t {
  char marker[10];    /* "TOPSYi386"'\0' */
  char filler1[6];    /* Unused space to reach 4Byte alignment */
  long tracksize;     /* Number of Tracks to read from disk */
  long codesize;      /* Size of Code Segment in file */
  long datasize;      /* Size of Data Segment in file */
  char filler2[36];   /* Undefined in BinaryFileDesc */
} BinaryFileDesc;

typedef BinaryFileDesc *BinFileDescPtr;

typedef struct DriverFileHeader_t {
  char marker[10];    /* "TOPSYi386"'\0' */
  char filler1[6];    /* Unused space to reach 4Byte alignment */
  long tracksize;     /* Number of Tracks to read from disk */
  long codesize;      /* Size of Code Segment in file */
  long datasize;      /* Size of Data Segment in file */
  long drivertable;   /* Address of Driver Table in file; my be located anywhere */
  char filler2[32];   /* undefined remain of space */
} DriverFileHeader;

typedef DriverFileHeader *DriverFileHeaderPtr;

#endif

