/*
    Startup.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Startup/Startup.c,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.26 $
 	Creation Date:        
 	Last Date of Change:   $Date: 1999/12/13 21:48:32 $      by: $Author: ruf $
	
	
	$Log: Startup.c,v $
	Revision 1.26  1999/12/13 21:48:32  ruf
	GNU General Public Licence Update
	
	Revision 1.25  1999/10/30 13:09:11  gfa
	double init string removed...
	
	Revision 1.24  1999/10/27 11:05:00  jeker
	fixes R4k R3k port

	Revision 1.23  1999/09/17 07:55:11  gfa
	new automatic version string

	Revision 1.22  1999/05/20 15:08:40  jeker
	little changes for ia32 port

	Revision 1.21  1999/04/08 11:40:13  jeker
	added some new files, modified some others for unix port

	Revision 1.20  1999/01/06 17:47:35  cjeker
	code cleaning

	Revision 1.19  1998/06/09 17:44:38  gfa
	removed __main()
	
	Revision 1.18  1997/04/07 07:47:50  gfa
	added __main (now we have a function less in ./mips but the compiler
	issues a warning...)

 * Revision 1.17  97/03/24  20:34:08  gfa
 * removed hmStack parameter
 * 
 * Revision 1.16  1997/03/23  12:43:34  gfa
 * moved boot msg to config
 *
 * Revision 1.15  97/03/22  14:30:34  conrad
 * locks replace msg for heap
 * 
 * Revision 1.14  1997/03/19  08:11:51  gfa
 * ioConsoleInit, new version string
 *
 * Revision 1.13  1997/03/16  19:31:00  gfa
 * first kernel version with kernel threads and user running
 *
 * Revision 1.12  1997/03/12  18:59:56  gfa
 * *** empty log message ***
 *
 * Revision 1.11  1997/03/12  18:52:43  gfa
 * *** empty log message ***
 *
 * Revision 1.10  1997/03/11  08:12:27  gfa
 * added initBasicException()
 *
 * Revision 1.9  1997/03/10  10:34:09  gfa
 * added parameters for hmStack address
 *
 * Revision 1.8  1997/03/09  20:51:02  gfa
 * userJump needs to be preserved *before* calling mmInit()
 *
 * Revision 1.7  1997/03/04  16:03:51  gfa
 * *** empty log message ***
 *
 * Revision 1.6  1997/03/04  15:58:48  gfa
 * added $Id: Startup.c,v 1.26 1999/12/13 21:48:32 ruf Exp $ in addition to boot message
 *
 * Revision 1.5  1997/03/04  15:57:29  gfa
 * *** empty log message ***
 *
 * Revision 1.4  1997/03/04  10:10:21  gfa
 * simplified call to mmInit, introduced boot message
 *
 * Revision 1.3  1997/02/13  15:47:53  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.2  1997/02/12  15:47:53  gfa
 * calling both mmInit and tmInit now... using PANIC macro
 *
 * Revision 1.1  1997/02/04  11:42:25  topsy
 * Initial revision
 *
*/

#include "Startup.h"
#include "Memory.h"
#include "Threads.h"
#include "IO.h"
#include "IOHal.h"
#include "Configuration.h"
#include "Version.h"

extern SegMapPtr segmap;

void topsyMain() {
    Address mmStack, tmStack;
    Address userJump = ((SegMapPtr)segmap)->userJumpAddress;

    
    initBasicExceptions();			    /* catch traps early */
    ioConsoleInit();				    /* set baud 9600 etc. */
    ioConsolePutString(topsyVersionString);         /* from Topsy/Version.h */
    mmInit((SegMapPtr)segmap, &mmStack, &tmStack);  
    tmInit(mmStack, tmStack, userJump);            /* startup thread init */
    PANIC("init returned");			  /* mm/tmInit never returns */
}

