/*
    Copyright 2000 (c) by Reto Gaehler, Toni Kaufmann,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/TCP/nettcpTimer.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:39 $      by: $Author: gfa $


    $Log: nettcpTimer.h,v $
    Revision 1.1  2000/03/31 17:50:39  gfa
    Merged with /Net from several term projects

*/

#ifndef _NETTCPTIMER_H
#define _NETTCPTIMER_H

#include "Ports.h"
#include "TMTimer.h"

//**************************************************************************************************
//	module interface
//**************************************************************************************************

//**************************************************************************************************
//	tcp_tmInit
//	starts the user timer thread
//**************************************************************************************************
int tcp_tmInit();

//**************************************************************************************************
//	tcp_tmLeft
//	returns the remaining time of a tcp timer queue element
//**************************************************************************************************
int tcp_tmLeft(PortPtr pPort,void *pMsg, unsigned long u32Msg);

//**************************************************************************************************
//	tcp_tmClear
//	removes a tcp timer queue element
//**************************************************************************************************
int tcp_tmClear(PortPtr pPort,void *pMsg, unsigned long u32Msg);

//**************************************************************************************************
//	tcp_tmSet
//	inserts a tcp timer queue element
//**************************************************************************************************
int tcp_tmSet(PortPtr pPort, int portlen,void *pMsg, unsigned long u32Msg, int nTime);

#endif
