/*
    Copyright 2000 (c) by Reto Gaehler, Toni Kaufmann,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/TCP/nettcpTimer.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:39 $      by: $Author: gfa $


    $Log: nettcpTimer.c,v $
    Revision 1.1  2000/03/31 17:50:39  gfa
    Merged with /Net from several term projects

*/

#include "nettcpConfig.h"
#include "nettcpTimer.h"
#include "NetDebug.h"
#include <Topsy.h>
#include <Messages.h>
#include <Syscall.h>

//**************************************************************************************************
//	tcp_tmUserTimerCallBack
//	called from user timer as soon as a tcp timer event occures
//**************************************************************************************************
void tcp_tmUserTimerCallBack(void *pMsg1,void *pMsg2, unsigned long u32Msg)
{
	PortPtr 	pPort;

	netdbgPrintf(NETDEBUG_TCP,"NetTcp Timer Expired Port: %p pTCB: %p Event: %d\n",pMsg1,pMsg2,u32Msg);
	pPort=(PortPtr)pMsg1;
 	if (ptCount(pPort) <= pPort->nsMaxMsg)
		ptSend(pPort,pMsg2,u32Msg);
}

//**************************************************************************************************
//	tcp_tmLeft
//	returns the remaining time of a tcp timer queue element
//**************************************************************************************************
int tcp_tmLeft(PortPtr pPort,void *pMsg, unsigned long u32Msg)
{
#if TCP_TIMER_OFF
	return TIMER_OK;
#else
	int res;

	res = tmUserTimerLeft(tcp_tmUserTimerCallBack,(void*)pPort,pMsg,u32Msg);
	if (res >= 0)
		return res;
	else
		return TIMER_FAILED;
#endif
}
//**************************************************************************************************
//	tcp_tmClear
//	removes a tcp timer queue element
//**************************************************************************************************
int tcp_tmClear(PortPtr pPort,void *pMsg, unsigned long u32Msg)
{
#if TCP_TIMER_OFF
	return TIMER_OK;
#else
	int res;

	res = tmUserTimerClear(tcp_tmUserTimerCallBack,(void*)pPort,pMsg,u32Msg);
	if (res >= 0)
		return res;
	else
		return TIMER_FAILED;
#endif
}
//**************************************************************************************************
//	tcp_tmSet
//	inserts a tcp timer queue element
//**************************************************************************************************
int tcp_tmSet(PortPtr pPort, int portlen,void *pMsg, unsigned long u32Msg, int nTime)
{
#if TCP_TIMER_OFF
	return TIMER_OK;
#else
	return tmUserTimerSet(tcp_tmUserTimerCallBack,(void*)pPort,pMsg,u32Msg,nTime,FALSE);
#endif
}


























