/*
    Copyright 2000 (c) by Reto Gaehler, Toni Kaufmann,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/TCP/nettcpSocket.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:39 $      by: $Author: gfa $


    $Log: nettcpSocket.h,v $
    Revision 1.1  2000/03/31 17:50:39  gfa
    Merged with /Net from several term projects

*/

#ifndef __NETTCPSOCKET_H
#define __NETTCPSOCKET_H

#include "nettcpTCP.h"

//**************************************************************************************************
//	definitions
//**************************************************************************************************

#define TCP_SEND_URGENT					true		// urgent data processing
#define TCP_SEND_NORMAL					false		// normal data processing

#define	TCP_CONTROL_LISTEN_QUEUE		0x01		// set the listen queue length
#define	TCP_CONTROL_ACCEPT				0x02		// wait for connect after passive open
#define	TCP_CONTROL_STATUS				0x03		// return status info (all, for master)
#define	TCP_CONTROL_SET_USER_OPTION		0x04		// set user-selectable options
#define	TCP_CONTROL_CLR_USER_OPTION		0x05		// clear user-selectable options
#define	TCP_CONTROL_SEND_URGENT			0x06		// write urgent data

#define	TCP_PPORT_RESERVED				1024		// from BSD (server uses ports 1 - 1023
#define	TCP_ANY_LOCAL_PORT				0			// assign a fresh local port num
#define	TCP_ANY_FOREIGN_PORT			0			// accept any foreign UDP port

//**************************************************************************************************
//	type definitions
//**************************************************************************************************

// server statistics
typedef struct 
{
	unsigned long	u32Connections;					// connections
	unsigned long	u32Resets;						// aborts
	unsigned long	u32Retransmissions;				// retransmissions
	unsigned long	u32PassiveOpens;				// passive opens
} TCPServerStatisticRec;

// connection statistics
typedef struct 
{
	NetAttrs		netParams;						// src/dst tcp port/ip num
	unsigned long	u32ReceiveWindow;				// receive window
	unsigned long	u32SendWindow;					// peer's window
	TCPStateSet		setState;						// TCP state
	long			n32SndUnacked;					// unacked seq
} TCPConnectionStatisticRec;

// statistics union
typedef union
{
	TCPServerStatisticRec		recServer;
	TCPConnectionStatisticRec	recConnection;
}  TCPStatisticsUon;

//	master statistic data structure
typedef struct 
{
	unsigned long		u32InputError;				// bad packet received
	unsigned long		u32AttempFailed;			// connection attempt failed
	unsigned long		u32TcpCurrEstab;			// current connection established
	unsigned long		u32TcpOutSegs;				// sent segments
	unsigned long		u32TcpOutRsts;				// sent resets
	TCPTypeSet			setType;					// kind of TCP status
	TCPStatisticsUon	uon;
} TCPStatisticsRec,*TCPStatisticsPtr;

// socket
typedef struct
{
	TCBPtr		pTCB;
	Boolean		bUrgentMode;
} SocketRec,*SocketPtr;


//**************************************************************************************************
//	module interface
//**************************************************************************************************

//**************************************************************************************************
//	tcpOpen
//  opens a fresh TCP pseudo device and returns a socket
//**************************************************************************************************
	int										// returns TCP_NO_ERR if successful
tcpOpen(
	IPAddressPtr	pIPSrcAddr,				// source ip addrs
	IPAddressPtr	pIPDstAddr,				// dest ip addrs
	unsigned short	u16SrcPort,				// local tcp port or TCP_ANY_LOCAL_PORT
	unsigned short	u16DstPort,				// TCP_ANY_FOREIGN_PORT = Server
	SocketPtr		*ppSocket);				//

//**************************************************************************************************
//	tcpClose
//**************************************************************************************************
	int
tcpClose(
	SocketPtr pSocket);

//**************************************************************************************************
//	tcpControl
//	controls function for TCP pseudo-devices
//**************************************************************************************************
	int										// Error code, or TCP_NO_ERR
tcpControl(
	SocketPtr 	pSocket,					// socket
	int			nOperation,					// control operation
	void		*arg,						// argument 1 of operation
	void 		*arg2,						// argument 2 of operation
	void		**pResult);					// returns a new socket

//**************************************************************************************************
//	tcpWrite
//	writes urgent and normal data to TCP buffers.
//**************************************************************************************************
	int										// returns number of sent bytes or error code (<0)
tcpWrite(									// transmits data
	SocketPtr 		pSocket,				// socket ptr
	unsigned char	*pu8SrcBuf,				// source data buffer
	unsigned long	u32Len,					// length of source data buffer
	Boolean			bIsUrgent);				// if true, urgent data processing will be used

//**************************************************************************************************
//	tcpRead
//	reads urgent and normal data to TCP buffers.
//**************************************************************************************************
	int										// num of bytes read or TCPE_URGENTMODE/TCPE_NORMALMODE
tcpRead(
	SocketPtr 		pSocket,				// socket
	unsigned char	*pu8SrcBuf,				// user buffer
	unsigned long	u32Len);				// size of buffer
	
//**************************************************************************************************
//	tcpStatistics
//	return status information for a TCP device
//**************************************************************************************************
	void
tcpStatistics(
	TCBPtr				pTCB,				// tcb, for which the statistic is requested
	TCPStatisticsPtr 	pStatistics);		// pointer to statistic data structure

//**************************************************************************************************
//	tcpNewSocket
//	Allocates and initialzes an new socket
//**************************************************************************************************
	int										// result code. returns TCP_OK if success
tcpNewSocket(
	SocketPtr *ppSocket);					


#endif