/*
    Copyright 2000 (c) by Reto Gaehler, Toni Kaufmann,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/TCP/nettcpMain.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.2 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/04/03 17:45:30 $      by: $Author: gfa $


    $Log: nettcpMain.c,v $
    Revision 1.2  2000/04/03 17:45:30  gfa
    *** empty log message ***

    Revision 1.1  2000/03/31 17:50:38  gfa
    Merged with /Net from several term projects

*/

#include "nettcpTCP.h"
#include "nettcpMain.h"

//**************************************************************************************************
//	tcp includes
//**************************************************************************************************

//**************************************************************************************************
//	globals
//**************************************************************************************************
SemaphoreRec	gTCBLinkedListMutex;
PortRec			gOutputPort;
int				gnListenQueueSize;

//**************************************************************************************************
//	prototypes
//**************************************************************************************************

static void nettcpUp(NetBuf buf,NetAttrs attrs);

#ifdef MacOS
	pascal static void *nettcpMain(ThreadArg arg);
#else
	static void nettcpMain(ThreadArg arg);
#endif

//**************************************************************************************************
//	nettcpInit
//**************************************************************************************************
	void 
nettcpInit()
{
	ThreadId	nettcpId;
	ThreadId	nettcpoutId;
	
	/* parts from tcpinit */
	semInit(&gTCBLinkedListMutex,1);
	gnListenQueueSize = 5;				/* default listen Q size	*/
	
	if (pqInitq() == GPQ_OK)
	{

		// Start main thread
		if (tmStart(&nettcpId,nettcpMain,(ThreadArg)0, "nettcp") == TM_STARTOK) 
		{
			
			// Start out thread
			if (tmStart(&nettcpoutId,tcpOut,(ThreadArg)0, "nettcpout") != TM_STARTOK) 
				netdbgDisplay(NETDEBUG_TCP, "Start: couldn't start tcp out thread\n");
		}
		else
			netdbgDisplay(NETDEBUG_GENERIC, "Start: couldn't start tcp thread\n");
	}
	else
		netdbgDisplay(NETDEBUG_GENERIC, "TCP: nettcpInit (pqInitq() failed)\n");
}

//**************************************************************************************************
//	nettcpMain
//**************************************************************************************************
#ifdef MacOS
pascal static void *nettcpMain(ThreadArg arg)
#else
static void nettcpMain(ThreadArg arg)
#endif
{
	ThreadId	myThreadId,parentThreadId;
	NetModMsg	msg;

	tmGetInfo(SELF,&myThreadId,&parentThreadId);

	// Add to list of modules
	netmodAdd(NETMODULE_TCP_IN,myThreadId);
	
	netdbgPrintf(NETDEBUG_MODULES,"tcp module started (moduleId=%d,threadId=%d).\n",
																NETMODULE_TCP_IN,myThreadId);

	while(TRUE) 
	{
		if(!netmodMsgRecv(&msg)) return;
		switch (msg.id) 
		{
			case NETMOD_SENDUP:
				nettcpUp(msg.buf,msg.attrs);
				break;
			case NETMOD_SENDDOWN:
				break;
			case NETMOD_LISTEN:
				break;
			case NETMOD_CLOSE:
				break;
			break;
			default:
				netdbgPrintf(NETDEBUG_GENERIC,"*** ERROR: tcp: Unknown message (%d)!\n",msg.id);
			break;
		}
	}
}

//**************************************************************************************************
//	nettcpUp
//**************************************************************************************************
	static void 
nettcpUp(
	NetBuf 		buf, 
	NetAttrs 	attrs)
{
	tcpInput(buf,attrs);
}

















