/*
    Copyright 2000 (c) by Reto Gaehler, Toni Kaufmann,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/TCP/nettcpEcho.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.2 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/04/03 17:45:30 $      by: $Author: gfa $


    $Log: nettcpEcho.c,v $
    Revision 1.2  2000/04/03 17:45:30  gfa
    *** empty log message ***

    Revision 1.1  2000/03/31 17:50:38  gfa
    Merged with /Net from several term projects

*/

//	This is the tcp core module. It contains the state dispatcher


#include "nettcpTimer.h"
#include "nettcpTCP.h"
#include "nettcpMain.h"
#include "nettcpSocket.h"
#include "nettcpEcho.h"

#ifdef MacOS
pascal void *tcpEchoProcess(ThreadArg arg);
#else
void tcpEchoProcess(ThreadArg arg);
#endif

//**************************************************************************************************
//	the TCP echo process
//**************************************************************************************************
#define TCP_ECHO_BUFFER_LEN	512
#ifdef MacOS
pascal void *tcpEchoProcess(ThreadArg arg)
#else
void tcpEchoProcess(ThreadArg arg)
#endif
{
	char		buf[TCP_ECHO_BUFFER_LEN];
	char		cChar;
	int			nResult;
	SocketPtr	pSocket = (SocketPtr)arg;

	netdbgDisplay(NETDEBUG_TCP,"echo process started\n");
	while (TRUE)
	{
		nResult = tcpRead(pSocket,(unsigned char *)&cChar,1);
		if (nResult == TCP_URGENTMODE || nResult == TCP_NORMALMODE) continue;
		if (nResult <= 0 || nResult == TCP_GENERAL_ERROR) break; 
		
		nResult = tcpWrite(pSocket,(unsigned char*)&cChar,1,FALSE);
		if (nResult <= 0 || nResult == TCP_GENERAL_ERROR) break;
	}
	
	nResult = tcpClose(pSocket);
	
	netdbgDisplay(NETDEBUG_TCP, "echo process terminated\n");
}

//**************************************************************************************************
//	the TCP echo server
//**************************************************************************************************
#ifdef MacOS
pascal void *tcpEchoDeamon(ThreadArg arg)
#else
void tcpEchoDeamon(ThreadArg arg)
#endif
{
	IPAddressUon	uonSrcAddr;
	IPAddressUon	uonDstAddr;
	int				nError;
	SocketPtr		pServerSocket;
	SocketPtr		pSocket;
	ThreadId		echoID;
	void			*pTmp;
	char			cChar;			

	uonSrcAddr.u32Addr = 0xC0A80202;		// 192.168.2.2
	uonDstAddr.u32Addr = 0xC0A80201;		// 192.168.2.1
	
	nError = tcpOpen(&uonSrcAddr,&uonDstAddr,7,TCP_ANY_FOREIGN_PORT,&pServerSocket);
	if (nError == TCP_NO_ERR)
	{
		nError = tcpControl(pServerSocket,TCP_CONTROL_LISTEN_QUEUE,(void*)10,(void*)0,&pTmp);
		if (nError == TCP_NO_ERR)
		{
			netdbgPrintf(NETDEBUG_TCP, "echod is started\n");
			while (TRUE)
			{
				nError = tcpControl(pServerSocket,TCP_CONTROL_ACCEPT,(void*)0,(void*)0,&pSocket);
				if ((nError != TCP_NO_ERR) && (pSocket != NULL))
				{
					netdbgDisplay(NETDEBUG_TCP, "echod failed\n");
					break;
				}
				else
					netdbgDisplay(NETDEBUG_TCP,"echo client connected successfully\n");
	
				tcpControl(pSocket,TCP_CONTROL_SET_USER_OPTION,TCP_TCB_BUFFER,(void*)0,(void*)0);

				if (tmStart(&echoID,tcpEchoProcess,(ThreadArg)pSocket,"tcpEchoDeamon") != TM_STARTOK)
					netdbgDisplay(NETDEBUG_TCP,"echod error\n");

			}
		}
		else
			netdbgDisplay(NETDEBUG_TCP,"echod error tcpControl\n");
	}
	else
		netdbgDisplay(NETDEBUG_TCP,"echod error tcpOpen\n");
}

//**************************************************************************************************
//	tcpEchod
//**************************************************************************************************
	int 
tcpEchod(void)
{
	long			echoThreadId;
	int				nResult;
	unsigned char	message[] = "Hello new world.\n";
	unsigned char	u8Len = sizeof(message);
	
	if (tmStart(&echoThreadId,tcpEchoDeamon,(ThreadArg)0,"Echo_Server_Thread") != TM_STARTOK)
		return TCP_GENERAL_ERROR;

	while (TRUE)
		tmYield();	
}


































