/*
    Copyright 2000 (c) by Reto Gaehler, Toni Kaufmann,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/TCP/Ports.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.2 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/04/03 17:45:30 $      by: $Author: gfa $


    $Log: Ports.h,v $
    Revision 1.2  2000/04/03 17:45:30  gfa
    *** empty log message ***

    Revision 1.1  2000/03/31 17:50:37  gfa
    Merged with /Net from several term projects

*/
#ifndef _PORTS_H_
#define _PORTS_H_

#include <Topsy.h>
#include <Syscall.h>
#include "Semaphore.h"

//**************************************************************************************************
//	definitions
//**************************************************************************************************
#define PORT_MAX_NUM_OF_MSG	20

#define	PORT_FAILED			-1		
#define	PORT_OK				1		

#define	PTNODISP	0		/* ptclear() null disposal func */

//**************************************************************************************************
//	type definitions
//**************************************************************************************************

typedef enum
{
	PORT_FREE,
	PORT_LIMBO,
	PORT_ALLOC,
	PORT_EMptY
} PortStateSet;

typedef struct PortMsgRec
{	
	void *				pMsg;				
	unsigned long		u32Msg;				
	struct PortMsgRec	*pNext;				/* address of next node on list	*/
} PortMsgRec, *PortMsgPtr;

typedef struct
{		
	SemaphoreRec	recPortSem;		/* port semaphore		*/
	SemaphoreRec	recTxSem;			/* sender semaphore		*/
	SemaphoreRec	recRxSem;			/* receiver semaphore		*/
	int				nsMaxMsg;			/* max messages to be queued	*/
	int				nsSeqChg;			/* sequence changed at creation	*/
	PortMsgPtr		pMsgHead;			/* list of message pointers	*/
	PortMsgPtr		pMsgTail;			/* tail of message list		*/
	PortMsgPtr		pFree;	
	PortMsgRec		aryMsgBlock[PORT_MAX_NUM_OF_MSG];	
} PortRec, *PortPtr;

//**************************************************************************************************
//	module interface
//**************************************************************************************************

//**************************************************************************************************
//	ptInit
//	initializes a port
//**************************************************************************************************
int ptInit(PortPtr pPort,unsigned int uMaxNrOfMsg);

//**************************************************************************************************
//	ptDelete
//	deallocates a port
//**************************************************************************************************
int 	ptDelete(PortPtr pPort, void (*dispose)());

//**************************************************************************************************
//	ptReset
//	resets a port
//**************************************************************************************************
int 	ptReset(PortPtr pPort, void (*dispose)());

//**************************************************************************************************
//	ptCount
//	returns the number of messages of this port
//**************************************************************************************************
int		ptCount(PortPtr pPort);

//**************************************************************************************************
//	ptReceive
//	receives a Message from this port
//**************************************************************************************************
int		ptReceive(PortPtr pPort, void **msg, unsigned long *u32Msg);

//**************************************************************************************************
//	ptSend
//	sends a Message to this port
//**************************************************************************************************
int		ptSend(PortPtr pPort,void  *msg,unsigned long u32Msg);

#endif