/*
    Copyright 2000 (c) by Reto Gaehler, Toni Kaufmann,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/TCP/GPQueue.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.2 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/04/03 17:45:30 $      by: $Author: gfa $


    $Log: GPQueue.h,v $
    Revision 1.2  2000/04/03 17:45:30  gfa
    *** empty log message ***

    Revision 1.1  2000/03/31 17:50:37  gfa
    Merged with /Net from several term projects

*/
#ifndef _GPQUEUE_H_
#define _GPQUEUE_H_

#include <Topsy.h>
#include "Semaphore.h"

//**************************************************************************************************
//	definitions
//**************************************************************************************************

#define GPQ_FAILED 	-1
#define GPQ_OK 		1

#define	EMPTY		(-1)

//**************************************************************************************************
//	type definitions
//**************************************************************************************************

typedef struct	qinfo {
	Boolean			q_valid;
	int				q_max;
	int				q_count;
	int				q_seen;
	SemaphoreRec	q_mutex;
	int				*q_key;
	char			**q_elt;
} qinfo, *qinfoptr;

#define	MAXNQ	100

//**************************************************************************************************
//	module interface
//**************************************************************************************************

//**************************************************************************************************
//	pqEnq
//	inserts an element
//**************************************************************************************************
int 	pqEnq(int q, void *elt, int key);

//**************************************************************************************************
//	pqDeq
//	removes and returns an element
//**************************************************************************************************
void* 	pqDeq(int q);

//**************************************************************************************************
//	pqHeadq
//	returns the first element without removing
//**************************************************************************************************
void* 	pqHeadq(int q);

//**************************************************************************************************
//	pqSeeq
//	peek at queue elements in order, without removing them
//	return the elements until all out; then return NULL and reset q_seen
//**************************************************************************************************
void* 	pqSeeq(int q);

//**************************************************************************************************
//	pqNewq
//	allocate a new queue, return the queue's index
//**************************************************************************************************
int 	pqNewq(unsigned size);

//**************************************************************************************************
//	pqFreeq
//	deallocate a queue
//**************************************************************************************************
int 	pqFreeq(int q);

//**************************************************************************************************
//	pqLenq
//	returns number of elements in queue
//**************************************************************************************************
int		pqLenq(int q);

//**************************************************************************************************
//	pqInitq
//	initialize the queue
int		pqInitq();

#endif