/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/Skeleton/Skeleton.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:37 $      by: $Author: gfa $


    $Log: Skeleton.c,v $
    Revision 1.1  2000/03/31 17:50:37  gfa
    Merged with /Net from several term projects

*/
/* Skeleton for a net module. */
/* 1. Replace 'skl' with abbrevation (eth) */
/* 2. Replace 'skel' with full-name (ethernet) */
/* 3. Fill in netsklUp and netsklDown */

#include <Topsy.h>
#include <Messages.h>
#include <Syscall.h>

#include <NetDebug.h>
#include <NetBuf.h>
#include <NetAttr.h>
#include <NetConfig.h>
#include <NetModules.h>

static void netsklMain(ThreadArg arg);
static void netsklUp(NetBuf buf, NetAttrs attrs);
static void netsklDown(NetBuf buf, NetAttrs attrs);

void netsklInit()
{
	ThreadId netsklId;
	
	/* Start main thread */
	if (tmStart(&netsklId, netsklMain, (ThreadArg)0, "netskl") != TM_STARTOK) {
		netdbgDisplay(NETDEBUG_GENERIC, "Start: couldn't start skel thread\n");
		return;
	}
}

static void netsklMain(ThreadArg arg)
{
	ThreadId myThreadId, parentThreadId;
	NetModMsg msg;

	tmGetInfo(SELF, &myThreadId, &parentThreadId);

	/* Add to list of modules */
	netmodAdd(NETMODULE_SKEL, myThreadId);
	
	netdbgPrintf(NETDEBUG_MODULES,
		     "Skel module started (moduleId=%d, threadId=%d).\n",
		     NETMODULE_SKEL, myThreadId);

	while(1) {
		if(!netmodMsgRecv(&msg)) return;

		switch (msg.id) {
		case NETMOD_SENDUP:
			netsklUp(msg.buf, msg.attrs);
			break;
		case NETMOD_SENDDOWN:
			netsklDown(msg.buf, msg.attrs);
			break;
		default:
			netdbgPrintf(NETDEBUG_GENERIC,
				      "*** ERROR: Skel: Unknown message (%d)!\n",
				     msg.id);
			break;
		}
	}
}

static void netsklUp(NetBuf buf, NetAttrs attrs)
{
	/* Process packet and fill attrs */
	
	/* Send up packet */
	netcfgSendNextUp(NETMODULE_SKEL, buf, attrs);
}

static void netsklDown(NetBuf buf, NetAttrs attrs)
{
	/* Build header and fill attrs */
	
	/* Send down packet */
	netcfgSendNextDown(NETMODULE_SKEL, buf, attrs);
}
