// Semesterarbeit Topsy TCP/IP
// Reto Gaehler, Toni Kaufmann

#ifndef _sem_H_
#define _sem_H_

#include <Topsy.h>
#include <Lock.h>
#include <Syscall.h>

//	definitions
#define SEM_FAILED 		-1
#define SEM_OK 			1

// type definitions
typedef struct
{
	LockDesc recLock;
	int      nsCount;
} SemaphoreRec, *SemaphorePtr;

// module interface
int semInit(SemaphorePtr pSem, int nsCount);
int semReset(SemaphorePtr pSem, int nsCount);
int semCount(SemaphorePtr pSem);
int semWait(SemaphorePtr pSem);
int semSignal(SemaphorePtr pSem);
int semSignalIfLess(SemaphorePtr pSem, int cmpValue);

#endif