/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetTest.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:35 $      by: $Author: gfa $


    $Log: NetTest.c,v $
    Revision 1.1  2000/03/31 17:50:35  gfa
    Merged with /Net from several term projects

*/
#include <Topsy.h>
#include <Syscall.h>
#include <UserSupport.h>

#include <NetAttr.h>
#include <NetBuf.h>
#include <NetModules.h>
#include <NetDebug.h>

static ThreadId tty2;

void NetTestGetTime(ThreadArg arg)
{
	NetBuf buf;
	NetAttrs attrs;
	unsigned short port;
	NetModMsg msg;
	ThreadId tty;

	ioOpen(IO_CONSOLE, &tty);
	ioInit(tty);

	/* the daytime-protocol is as follows: send a UDP datagram to port 13
	 * (the contents arn't important) and then a reply UDP datagram
	 * containing a ASCII representation of time will be sent back */
	
	/* Send a listen request to the UDP module, with port-nr. 0, so that
	 * the first free port is reserved */
	netmodListen(NETMODULE_UDP, 0, 0);

	/* Wait for LISTENREPLY */
	if(!netmodMsgRecv(&msg)) return;

	/* msg.value contains the reserved port nr. */
	port = msg.value;
	netdbgPrintf(0,"port = %d\n",port);

	/* send empty UDP datagram */
	netbufAlloc(&buf, 0);
	netattrNew(&attrs);
	netattrSet(attrs, NETATTR_UDP_FROM, port);
	netattrSet(attrs, NETATTR_UDP_TO, 13);
	netattrSet(attrs, NETATTR_IP_TO_0, 192);
	netattrSet(attrs, NETATTR_IP_TO_1, 168);
	netattrSet(attrs, NETATTR_IP_TO_2, 2);
	netattrSet(attrs, NETATTR_IP_TO_3, 1);
	netmodSendDown(NETMODULE_UDP, buf, attrs);

	/* wait for reply containing the time-string */
	/* This could block if the destination address isn't resolved */
	/* because no answer will come :-( */
	if(!netmodMsgRecv(&msg)) return;
	buf = msg.buf;

	/* display string on screen */
	display(tty, NETBUF_DATA(buf));

	/* close port */
	netmodClose(NETMODULE_UDP, 0, port);
}

/* little server for udp port 100, which echoes on screen what it receives. */
void nettestUDP()
{
	/* Listen to the UDP port */
	netmodListen(NETMODULE_UDP, 0, 100);

	/* We will now receive packets from the UDP module */

	while(1) {
		NetModMsg msg;
		NetBuf buf;

		if(!netmodMsgRecv(&msg)) return;

		if(msg.id != NETMOD_SENDUP) {
			display(tty2,"unknown message!\n");
			continue;
		}
		
		buf = msg.buf;
		ioPrintf(tty2, "\nUDP datagram received (len=%d):\n", netbufLen(buf));
		display(tty2, "Attributes:\n");
		netattrDebug(0,"udp",msg.attrs); 
		display(tty2, "Contents: <");
		while(buf) {
			display(tty2, NETBUF_DATA(buf));
			buf = buf->next;
		}
		display(tty2, ">\n");
	}
}

void NetTest(ThreadArg arg)
{
	ThreadId threadid;

	ioOpen(IO_CONSOLE, &tty2);
	ioInit(tty2);

	/* Start udp-test-server */
	if (tmStart(&threadid, nettestUDP, (ThreadArg)0, "udp-test") != TM_STARTOK) {
		return;
	}
}
