/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetSyscall.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:35 $      by: $Author: gfa $


    $Log: NetSyscall.c,v $
    Revision 1.1  2000/03/31 17:50:35  gfa
    Merged with /Net from several term projects

*/
#include <Syscall.h>
#include <Net.h>
#include <NetDebug.h>
#include <NetSyscall.h>

/* Please don't call these directly, but use the netbufAlloc and netbufFree
   instead! */
SyscallError netAlloc(Address *addressPtr, unsigned long int size)
{
	Message message, reply;
    
	message.id = VM_ALLOC;
	message.msg.vmAlloc.size = size;
	reply.id = VM_ALLOCREPLY;
	
	if (genericSyscall(netMainId, &message, &reply) == TM_MSGSENDFAILED)
		return VM_ALLOCFAILED;
	
	*addressPtr = reply.msg.vmAllocReply.address;
    
	return reply.msg.vmAllocReply.errorCode;
}

SyscallError netFree(Address address)
{
    Message message, reply;
    
    message.id = VM_FREE;
    message.msg.vmFree.address = address;
    reply.id = VM_FREEREPLY;

    if (genericSyscall(netMainId, &message, &reply) == TM_MSGSENDFAILED)
    	return VM_FREEFAILED;
    
    return reply.msg.vmFreeReply.errorCode;
}
