/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetSupport.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:35 $      by: $Author: gfa $


    $Log: NetSupport.c,v $
    Revision 1.1  2000/03/31 17:50:35  gfa
    Merged with /Net from several term projects

*/
#define LONGSIZE (sizeof(long)/sizeof(char))
void memcpy(char *a, char *b, int len)
{
    long* tar = (long*)a;
    long* src = (long*)b;
    int rem;

    rem=len%LONGSIZE;
    len/=LONGSIZE;

    /* long copy */
    for (; len>0; len--) {
	*tar++ = *src++;
    }

    /* byte copy the remaining bytes */
    if(rem) {
	    a=(char *)(src-1);
	    b=(char *)(dst-1);
	    a++; b++;
	    for(;rem>0;rem--) *a++=*b++;
    }
}
