/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetModules.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:35 $      by: $Author: gfa $


    $Log: NetModules.h,v $
    Revision 1.1  2000/03/31 17:50:35  gfa
    Merged with /Net from several term projects

*/
#ifndef _NETMODULES_H
#define _NETMODULES_H

#include <Topsy.h>
#include <Syscall.h>
#include <Messages.h>
#include <NetBuf.h>
#include <NetAttr.h>

typedef enum {
	NETMODULE_ETHERTAP=1, NETMODULE_ETHERNET,
	NETMODULE_LINK,	NETMODULE_IP, NETMODULE_ARP,
	NETMODULE_ICMP, NETMODULE_UDP, 
	NETMODULE_TCP_IN,NETMODULE_TCP_OUT,
	NETMODULE_USER, NETMODULE_LAST
} NetModuleId;

typedef enum {
	NETMOD_SENDUP=UNKNOWN_SYSCALL+1, NETMOD_SENDDOWN,
	NETMOD_LISTEN, NETMOD_LISTENREPLY,
	NETMOD_CLOSE, NETMOD_LAST
} NetModMessageId;

typedef struct NetModSendMsg_t {
	ThreadId from;
	NetModMessageId id;
	NetBuf buf;
	NetAttrs attrs;
	long value;
	long value2;
	long value3;
	long value4;
	long value5;
} NetModMsg;

void netmodInit();
void netmodAdd(NetModuleId m, ThreadId t);
int  netmodMsgRecv(NetModMsg *msg);

void netmodSendUp(NetModuleId to, NetBuf buf, NetAttrs attrs);
void netmodSendDown(NetModuleId to, NetBuf buf, NetAttrs attrs);
void netmodListen(NetModuleId to, NetAttrs attrs, long value);
void netmodListenReply(NetModuleId to, NetAttrs attrs, long value);
void netmodClose(NetModuleId to, NetAttrs attrs, long value);

void netmodSendUpThread(ThreadId to, NetBuf buf, NetAttrs attrs);
void netmodSendDownThread(ThreadId to, NetBuf buf, NetAttrs attrs);
void netmodListenThread(ThreadId to, NetAttrs attrs, long value);
void netmodListenReplyThread(ThreadId to, NetAttrs attrs, long value);
void netmodCloseThread(ThreadId to, NetAttrs attrs, long value);

#endif
