/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetMain.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:34 $      by: $Author: gfa $


    $Log: NetMain.c,v $
    Revision 1.1  2000/03/31 17:50:34  gfa
    Merged with /Net from several term projects

*/
#include <Topsy.h>
#include <Ethertap/NetEthertap.h>
#include <Ethernet/NetEthernet.h>
#include <Net.h>
#include <NetSyscall.h>
#include <NetDebug.h>

ThreadId netMainId; /* Initialized in NetInit.c when starting netMain */

void netMain(ThreadArg arg)
{
	Message         msg, reply;
	Address         address;
	ThreadId	expectedFrom;

	reply.from = netMainId ; /* sent always from this thread */

	while(1) {
		expectedFrom = ANY;
		if (tmMsgRecv(&expectedFrom, ANYMSGTYPE, (Message *) &msg, INFINITY) == 
		    TM_MSGRECVFAILED) {
			netdbgDisplay(NETDEBUG_GENERIC, "*** ERROR: NetMain: Message receive error.\n");
			/* PANIC("message receive error!") ;*/
			return;
		}
		switch (msg.id) {
		case VM_ALLOC: /* used by the NetBuf allocator */
			reply.id = VM_ALLOCREPLY;
			if(vmAlloc(&address, msg.msg.vmAlloc.size)==VM_ALLOCOK)
				reply.msg.vmAllocReply.errorCode=VM_ALLOCOK;
			else
				reply.msg.vmAllocReply.errorCode=VM_ALLOCFAILED;
			reply.msg.vmAllocReply.address = address;
			netdbgPrintf(NETDEBUG_MEMORY, "vmAlloc(%d) -> %p\n",
				     msg.msg.vmAlloc.size, address);
			tmMsgSend(msg.from, &reply);
			break;
		case VM_FREE:
			reply.id = VM_FREEREPLY;
			if(vmFree(msg.msg.vmFree.address)==VM_FREEOK)
				reply.msg.vmFreeReply.errorCode=VM_FREEOK;
			else
				reply.msg.vmFreeReply.errorCode=VM_FREEFAILED;
			netdbgPrintf(NETDEBUG_MEMORY, "vmFree(%p)\n",
				     msg.msg.vmFree.address);
			tmMsgSend(msg.from, &reply);
			break;
		default:
			netdbgDisplay(NETDEBUG_GENERIC, "*** ERROR: NetMain: Unknown message\n");
			reply.id = UNKNOWN_SYSCALL;
			tmMsgSend(msg.from, &reply);
			break;
		}
			
	}
}
