/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetInit.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:34 $      by: $Author: gfa $


    $Log: NetInit.c,v $
    Revision 1.1  2000/03/31 17:50:34  gfa
    Merged with /Net from several term projects

*/
#include <Messages.h>
#include <Syscall.h>
#include <Net.h>
#include <NetDebug.h>
#include <NetIface.h>
#include <Ethernet/NetEthernet.h>
#include <ARP/NetARP.h>
#include <IP/NetIP.h>
#include <ICMP/NetICMP.h>
#include <UDP/NetUDP.h>
#include <TCP/nettcpMain.h>

void netMain(ThreadArg arg);

void netInit()
{
	/* Init debug facility */
	netdbgInit();
	netdbgDisplay(NETDEBUG_GENERIC, "Network started.\n");

	/* Start netMain */
	if(tmStart(&netMainId, netMain, NULL, "net")!=TM_STARTOK) {
		netdbgDisplay(NETDEBUG_GENERIC, "*** ERROR: Can't start networking.\n");
		return;
	}
	
	/* Init netbufs */
	netbufInit();

	/* Init inter-module communication */
	netmodInit();

	/* Init interfaces */
	netifInit();

	/* Init modules */
	netethInit();
	netarpInit();
	netipInit();
	neticmpInit();
	netudpInit();
	nettcpInit();

	/* Configure the network */
	
	/* Address: 192.168.2.2 */
	netifSetAttr(0, NETATTR_IP_FROM_0, 192);
	netifSetAttr(0, NETATTR_IP_FROM_1, 168);
	netifSetAttr(0, NETATTR_IP_FROM_2, 2);
	netifSetAttr(0, NETATTR_IP_FROM_3, 2);
}
