/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetIface.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:34 $      by: $Author: gfa $


    $Log: NetIface.h,v $
    Revision 1.1  2000/03/31 17:50:34  gfa
    Merged with /Net from several term projects

*/
#ifndef _NETIFACE_H
#define _NETIFACE_H

#include <Topsy.h>
#include <NetAttr.h>
#include <NetModules.h>

#define NETIF_IFCOUNT 1

struct NetIfDesc_t;

typedef void (*NetIfMainFunction)(struct NetIfDesc_t *);

typedef struct NetIfDesc_t {
	unsigned int       nr;      
	NetIfMainFunction  main;
	char               *name;
	NetModuleId        moduleId;
	NetAttrs           config;    /* Will be automatically allocated by
					 init. Leave NULL */
} NetIfDesc;

void netifInit();
void netifSetAttr(unsigned int iface, unsigned short attr, unsigned short data);
int netifGetAttr(unsigned int iface, unsigned short attr, unsigned short *data);

#endif
