/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetIface.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:34 $      by: $Author: gfa $


    $Log: NetIface.c,v $
    Revision 1.1  2000/03/31 17:50:34  gfa
    Merged with /Net from several term projects

*/
#include <Syscall.h>
#include <Ethertap/NetEthertap.h>
#include <NetDebug.h>
#include <NetIface.h>

static NetIfDesc netifTable[NETIF_IFCOUNT] = {
	{
		0,                      /* nr */
		nettapMain,             /* main function */
		"nettap",               /* name */
		NETMODULE_ETHERTAP,     /* moduleId */
		NULL                    /* config */
	}
};

void netifInit()
{
	int i;
	ThreadId child;

	for(i=0; i<NETIF_IFCOUNT; i++) {
		/* Alloc config */
		netattrNew(&(netifTable[i].config));

		/* Start main thread */
		if(tmStart(&child, (ThreadMainFunction) netifTable[i].main, netifTable+i,
			   netifTable[i].name) != TM_STARTOK) {
			netdbgDisplay(NETDEBUG_GENERIC,
				      "*** ERROR: Interface module could not be started\n");
			continue;
		}
	}
}

void netifSetAttr(unsigned int iface, unsigned short attr, unsigned short data)
{
	if(iface < NETIF_IFCOUNT) {
		netattrSet(netifTable[iface].config, attr, data);
	}
}

int netifGetAttr(unsigned int iface, unsigned short attr, unsigned short *data)
{
	if(iface < NETIF_IFCOUNT) {
		return netattrGet(netifTable[iface].config, attr, data);
	} else {
		return 0;
	}
}


