/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*
	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetIO.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:34 $      by: $Author: gfa $


    $Log: NetIO.c,v $
    Revision 1.1  2000/03/31 17:50:34  gfa
    Merged with /Net from several term projects


*/
#include <Syscall.h>
#include <NetBuf.h>
#include <NetDebug.h>

#include <NetIO.h>

/* Send each buf in linked list to device */
void netioWrite(ThreadId dev, NetBuf buf)
{
	unsigned long int len;
	
	while(buf) {
		len = NETBUF_LEN(buf);
		if(buf->next) {
			//netdbgPrintf(NETDEBUG_TCP, "netio: fragmented (%d)\n", len);
			ioWriteFlags(dev, NETBUF_DATA(buf), &len, 1);
		}
		else {
			//netdbgPrintf(NETDEBUG_TCP, "netio: all-in-one (%d)\n", len);
			ioWriteFlags(dev, NETBUF_DATA(buf), &len, 0);
		}
		buf=buf->next;
	}
}
