/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetDebug.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:34 $      by: $Author: gfa $


    $Log: NetDebug.h,v $
    Revision 1.1  2000/03/31 17:50:34  gfa
    Merged with /Net from several term projects

*/
#ifndef _NETDEBUG_H
#define _NETDEBUG_H

#include <Topsy.h>
#include <NetBuf.h>
#include <stdarg.h>

#define NETDEBUG_GENERIC  (1UL << 0)
#define NETDEBUG_MEMORY   (1UL << 1)
#define NETDEBUG_NETBUFS  (1UL << 2)
#define NETDEBUG_ETHERTAP (1UL << 3)
#define NETDEBUG_MODULES  (1UL << 4)
#define NETDEBUG_ETHERNET (1UL << 5)
#define NETDEBUG_ARP      (1UL << 6)
#define NETDEBUG_IP       (1UL << 7)
#define NETDEBUG_ICMP     (1UL << 8)
#define NETDEBUG_CONFIG   (1UL << 9)
#define NETDEBUG_UDP      (1UL << 10)
#define NETDEBUG_TCP      (1UL << 11)
#define NETDEBUG_TIMER    (1UL << 12)

/* CHANGE THIS: */
#define NETDEBUG
//#define NETDEBUG_MASK  ( NETDEBUG_GENERIC | NETDEBUG_MODULES | NETDEBUG_CONFIG | NETDEBUG_IP | NETDEBUG_UDP | NETDEBUG_ETHERNET | NETDEBUG_ETHERTAP )
//#define NETDEBUG_MASK  (NETDEBUG_TCP | NETDEBUG_IP | NETDEBUG_ETHERNET | NETDEBUG_ETHERTAP | NETDEBUG_CONFIG | NETDEBUG_TIMER)
#define NETDEBUG_MASK  (/*NETDEBUG_GENERIC |*/ NETDEBUG_TCP | NETDEBUG_TIMER)

#ifdef NETDEBUG
extern ThreadId netdbg_tty;
void netdbgInit();
void netdbgEnd();
void netdbgDisplay(unsigned long family, char *);
void netdbgPrintf(unsigned long family, char *fmt, ...);
void netdbgDumpBuf(unsigned long family, NetBuf buf);
#else
/* This is gcc... There is still some overhead -> to be removed at the end. */
inline static void netdbgInit() {}
inline static void netdbgEnd() {}
inline static void netdbgDisplay(unsigned long family, char *str) {}
inline static void netdbgPrintf(unsigned long family, char *fmt, ...) {}
inline static void netdbgDumpBuf(unsigned long family, NetBuf buf) {}
#endif

#endif
