/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetDebug.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:34 $      by: $Author: gfa $


    $Log: NetDebug.c,v $
    Revision 1.1  2000/03/31 17:50:34  gfa
    Merged with /Net from several term projects

*/
#include <Topsy.h>
#include <Syscall.h>
#include <IO.h>
#include <NetDebug.h>
#include <NetBuf.h>
#include <UserSupport.h>

#ifdef NETDEBUG

ThreadId netdbg_tty;

void netdbgInit() {
	ioOpen(IO_CONSOLE, &netdbg_tty);
	ioInit(netdbg_tty);
}

void netdbgEnd() {
	ioClose(netdbg_tty);
}

void netdbgDisplay(unsigned long family, char *str)
{
	if((family==0) || (family & NETDEBUG_MASK)) {
		display(netdbg_tty, str);
	}
}

void netdbgPrintf(unsigned long family, char *fmt, ...)
{
	va_list ap;
	unsigned long int len;
	char buf[200];

	if((family==0) || (family & NETDEBUG_MASK)) {
		va_start(ap, fmt);
		len = vsprintf(buf, fmt, ap);
		ioWrite(netdbg_tty, buf, &len);
		va_end(ap);
	}
}

void netdbgDumpBuf(unsigned long family, NetBuf buf)
{
	NetBuf	currBuf;
	
	currBuf=buf;
	while (currBuf)
	{
		int len=NETBUF_LEN(currBuf);
 	       char *ptr=NETBUF_DATA(currBuf);
	
		if(!(family & NETDEBUG_MASK)) return;

		netdbgPrintf(family, "next: %p, pool: %p, bufnr: %d, size: %d, start: %d, end: %d\n",
			     currBuf->next, currBuf->pool, currBuf->bufnr, currBuf->size, currBuf->start, currBuf->end);
	
		while(len>=4) {
			netdbgPrintf(family, "%p: %02x %02x %02x %02x\n", ptr,
				     (int) ptr[0],(int) ptr[1], (int) ptr[2], (int) ptr[3]);
			ptr+=4;
			len-=4;
		}
		currBuf=currBuf->next;
	}
	
}
void netdbgDumpBufLong(unsigned long family, NetBuf buf)
{
	NetBuf	currBuf;
	int		nCount=0;
	
	currBuf=buf;
	while (currBuf)
	{
		int len=NETBUF_LEN(currBuf);
 	       unsigned char *ptr=NETBUF_DATA(currBuf);
	
		if(!(family & NETDEBUG_MASK)) return;

		while(len>0) {
			if ((nCount%16)==0)  netdbgPrintf(family, "\n");
			netdbgPrintf(family, ",%d", *ptr++);
			len--;
			nCount++;
		}
		currBuf=currBuf->next;
	}
	
}

#endif
