/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetBuf.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:33 $      by: $Author: gfa $


    $Log: NetBuf.h,v $
    Revision 1.1  2000/03/31 17:50:33  gfa
    Merged with /Net from several term projects

*/
#ifndef _NETBUF_H
#define _NETBUF_H

#define ALIGN 4

/* NetBufsPool */
typedef struct NetBufsPoolHdr_t {
	struct NetBufsPoolHdr_t *prev;
	struct NetBufsPoolHdr_t *next;
	unsigned long      used;
	unsigned short     sizenr; /* use NETBUF_BUFSIZE(sizenr) to get real size. */
	unsigned short     dummy; /* align to long */
} NetBufsPoolHdr;
typedef NetBufsPoolHdr *NetBufsPool;

/* NetBuf */
typedef struct NetBufHdr_t {
	struct NetBufHdr_t *next;
	NetBufsPool         pool;  /* do not access!! */
	unsigned short      bufnr; /* do not access!! */
	unsigned short      size;  /* use macro */
	unsigned short      start; /* use macro */
	unsigned short      end;   /* use macro */
} NetBufHdr; /* size: 2*4+4*2=16 bytes */
typedef NetBufHdr *NetBuf;

#define NETBUF_POOLSIZE      4096
#define NETBUF_SIZES           6  /* Number of different possible sizes.
				     This if for 32 bit unsigned long!! */
#define NETBUF_SIZEOFUSED        (sizeof(unsigned long)*8)

#define NETBUF_MAXBUFS(s)        (NETBUF_SIZEOFUSED >> s)
#define NETBUF_HEADERSIZE        sizeof(struct NetBufHdr_t)
#define NETBUF_DATA(netbuf)      ((char *)netbuf+(netbuf)->start)
#define NETBUF_SIZE(netbuf)      ((netbuf)->size)
#define NETBUF_START(netbuf)     ((netbuf)->start)
#define NETBUF_END(netbuf)       ((netbuf)->end)
#define NETBUF_LEN(netbuf)       ((netbuf)->end-(netbuf)->start)
#define NETBUF_HEADSPACE(netbuf) ((netbuf)->start-NETBUF_HEADERSIZE)
#define NETBUF_TAILSPACE(netbuf) ((netbuf)->size+NETBUF_HEADERSIZE-(netbuf)->start-1)

/* NetBuf statistics */
struct NetBufStats_t {
	unsigned short sizes[NETBUF_SIZES];
	unsigned short pools[NETBUF_SIZES];
	unsigned short usage[NETBUF_SIZES];
};
typedef struct NetBufStats_t NetBufStats;
extern NetBufStats *netbufStats;


void netbufInit();
int  netbufAlloc(NetBuf *bufPtr, unsigned int size);
void netbufFree(NetBuf buf);
int  netbufAddHead(NetBuf *bufPtr, unsigned int len);
int  netbufAddTail(NetBuf *bufPtr, unsigned int len);
unsigned int netbufLen(NetBuf buf);
void netbufTrim(NetBuf buf, unsigned int len);
int netbufCopy(NetBuf *dest, NetBuf src, int pos, int len);
int netbufClone(NetBuf *dest, NetBuf src);

/* netbufWrite				 																	*/
/* Fills linear data into a allocated NetBuf (size of NetBuf must be n32Len+n32DestOffset). 	*/
/* n32DestOffset bytes are and not changed at the beginning of the buffer						*/
long netbufWrite(NetBuf pDest,unsigned char *pSrc,long n32Len,long n32DestOffset);

/* netbufRead				 																	*/
/* Fills NetBuf into a allocated linear buffer (size of the linear buffer must be n32Len)		*/
/* The first n32SrcOffset bytes in the NetBuf are not copied									*/
long netbufRead(unsigned char *pDest,NetBuf pSrc,long n32Len,long n32SrcOffset);

void netbufStatistics();

#endif
