/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*
	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetBitFields.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:33 $      by: $Author: gfa $


    $Log: NetBitFields.h,v $
    Revision 1.1  2000/03/31 17:50:33  gfa
    Merged with /Net from several term projects


*/
#ifndef _NETBITFIELDS_H
#define _NETBITFIELDS_H

/* Bit-Fields (don't work on mips-gcc?)
 *
 * Byte (bit: BBITn(x))
 * |  0 |  1 |  2 |  3 |  4 |  5 |  6 |  7 |
 * | BDUAL0  | BDUAL1  | BDUAL2  | BDUAL3  |
 * | BNIBBLE0          | BNIBBLE1          |
 *
 * Word: (bit: WBITn(x))
 * |  0 |  1 |  2 |  3 |  4 |  5 |  6 |  7 |  8 |  9 | 10 | 11 | 12 | 13 | 14 | 15 |
 * | WDUAL0  | WDUAL1  | WDUAL2  | WDUAL3  | WDUAL4  | WDUAL5  | WDUAL6  | WDUAL7  |
 * | WNIBBLE0          | WNIBBLE1          | WNIBBLE2          | WNIBBLE3          |
 *
 * B = Byte (8 bit), W = Word (16 bit), L = Long (32 bit)
 */


#define BBITSHIFT(n)    (7-n)
#define WBITSHIFT(n)    (15-n)
#define LBITSHIFT(n)    (31-n)
#define BDUALSHIFT(n)   (6-(n<<1))
#define WDUALSHIFT(n)   (14-(n<<1))
#define LDUALSHIFT(n)   (30-(n<<1))
#define BNIBSHIFT(n)    (4-(n<<2))
#define WNIBSHIFT(n)    (12-(n<<2))
#define LNIBSHIFT(n)    (28-(n<<2))

#define BBITMASK(n)     (0x01<<BBITSHIFT(n))
#define WBITMASK(n)     (0x01<<WBITSHIFT(n))
#define LBITMASK(n)     (0x01<<LBITSHIFT(n))
#define BDUALMASK(n)    (0x03<<BDUALSHIFT(n))
#define WDUALMASK(n)    (0x03<<WDUALSHIFT(n))
#define LDUALMASK(n)    (0x03<<LDUALSHIFT(n))
#define BNIBMASK(n)     (0x0F<<BNIBSHIFT(n))
#define WNIBMASK(n)     (0x0F<<WNIBSHIFT(n))
#define LNIBMASK(n)     (0x0F<<LNIBSHIFT(n))

#define BBITGET(x,n)    (((x) & BBITMASK(n))>>BBITSHIFT(n))
#define WBITGET(x,n)    (((x) & WBITMASK(n))>>WBITSHIFT(n))
#define LBITGET(x,n)    (((x) & LBITMASK(n))>>LBITSHIFT(n))
#define BDUALGET(x,n)   (((x) & BDUALMASK(n))>>BDUALSHIFT(n))
#define WDUALGET(x,n)   (((x) & WDUALMASK(n))>>WDUALSHIFT(n))
#define LDUALGET(x,n)   (((x) & LDUALMASK(n))>>LDUALSHIFT(n))
#define BNIBGET(x,n)    (((x) & BNIBMASK(n))>>BNIBSHIFT(n))
#define WNIBGET(x,n)    (((x) & WNIBMASK(n))>>WNIBSHIFT(n))
#define LNIBGET(x,n)    (((x) & LNIBMASK(n))>>LNIBSHIFT(n))

#define BBITSET(x,n,v)  (v?x|=1<<BBITSHIFT(n):x^=1<<BBITSHIFT(n))
#define WBITSET(x,n,v)  (v?x|=1<<WBITSHIFT(n):x^=1<<WBITSHIFT(n))
#define LBITSET(x,n,v)  (v?x|=1<<LBITSHIFT(n):x^=1<<LBITSHIFT(n))
#define BDUALSET(x,n,v) (x=((x)&~BDUALMASK(n)) | (v<<BDUALSHIFT(n)))
#define WDUALSET(x,n,v) (x=((x)&~WDUALMASK(n)) | (v<<WDUALSHIFT(n)))
#define LDUALSET(x,n,v) (x=((x)&~LDUALMASK(n)) | (v<<LDUALSHIFT(n)))
#define BNIBSET(x,n,v)  (x=((x)&~BNIBMASK(n) ) | (v<<BNIBSHIFT(n) ))
#define WNIBSET(x,n,v)  (x=((x)&~WNIBMASK(n) ) | (v<<WNIBSHIFT(n) ))
#define LNIBSET(x,n,v)  (x=((x)&~LNIBMASK(n) ) | (v<<LNIBSHIFT(n) ))

#endif
